package com.xebialabs.xlrelease.script.groovy

import com.xebialabs.xlrelease.script.security.SandboxSupport
import grizzled.slf4j.Logging
import groovy.lang.{Closure, Script}
import org.kohsuke.groovy.sandbox.GroovyValueFilter

class GroovyScriptSandbox() extends GroovyValueFilter with SandboxSupport with Logging {
  def execute(closure: () => AnyRef): AnyRef = {
    this.register()
    val result = closure()
    this.unregister()
    result
  }

  override def filterReceiver(receiver: AnyRef): AnyRef = {
    if (isExternalReceiver(receiver)) {
      val target = getTarget(receiver)
      if (!hasClassAccess(target)) {
        val message = s"Loading the restricted class [$target] is not allowed. Please update the script.policy file if you wish to grant access."
        logger.warn(message)
        throw new SecurityException(message)
      }
    }
    receiver
  }

  private def isExternalReceiver(receiver: AnyRef): Boolean = {
    receiver != null && !receiver.isInstanceOf[Closure[_]] && !receiver.isInstanceOf[Script]
  }

  private def getTarget(receiver: AnyRef) = {
    (receiver match {
      case clazz: Class[_] => clazz
      case _ => receiver.getClass
    }) match {
      case clazz if clazz.getPackage == null || clazz.getPackage.getName == "" => s"default.${clazz.getName}"
      case clazz => clazz.getName
    }
  }
}
