package com.xebialabs.xlrelease.validation

import com.xebialabs.deployit.ClosingExceptionMapper.{X_EXCEPTION_TYPE, X_PATH}
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor
import com.xebialabs.deployit.rest.mappers.DeployitExceptionHandler
import com.xebialabs.deployit.service.validation.Validator
import com.xebialabs.deployit.{ClosingExceptionMapper, Exceptions, ServerConfiguration}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.Date
import javax.ws.rs.core.{MediaType, Response}
import javax.ws.rs.ext.{ExceptionMapper, Provider}

@Provider
@Component
class XlrValidationsFailedExceptionMapper @Autowired()(val config: ServerConfiguration)
  extends ClosingExceptionMapper[XlrValidationsFailedException](config.isHideInternals)
    with ExceptionMapper[XlrValidationsFailedException] {

  override protected def handleException(exception: XlrValidationsFailedException): Response = {
    val content: String = Exceptions.getAllMessages(exception)
    val status: Int = 400
    val handled: Response = checkWhetherWeHideInternals(status, exception, content)
    if (handled != null) {
      handled
    } else {
      val response: Response.ResponseBuilder = Response.status(status)
      response.header("X-Validation-Exception", "true")
      response.header(X_EXCEPTION_TYPE, exception.getClass.getName)
      response.header(X_PATH, PathInterceptor.PATH.get)
      response.header("Date", new Date)
      response.entity(DeployitExceptionHandler.getJsonEntity(new Validator.ValidationsFailedException(exception.getEntity)))
      response.header("X-Entity", "true")
      response.`type`(MediaType.APPLICATION_JSON_TYPE)
      response.build
    }
  }
}
