package com.xebialabs.xlrelease.views;

import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.metadata.Version;

public class PluginView {
    protected String artifactId;

    protected String version;

    public PluginView() {
    }

    public PluginView(PluginId pluginId) {
        PluginId.PluginIdOps pluginIdWithOps = new PluginId.PluginIdOps(pluginId);

        this.artifactId = pluginIdWithOps.pluginName();
        this.version = getVersionString(pluginIdWithOps);
    }

    private String getVersionString(PluginId.PluginIdOps plugin) {
        if (plugin.pluginVersion().isEmpty()) {
            return "N/A";
        } else {
            return new Version.VersionOps(plugin.pluginVersion().get()).id();
        }
    }

    public String getArtifactId() {
        return artifactId;
    }

    public void setArtifactId(final String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(final String version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return String.format("%s:%s", artifactId, version);
    }
}
