package com.xebialabs.xlrelease.mbeans;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.config.ArchivingSettingsManager;

@Component
@ManagedResource(objectName = "com.xebialabs.xlrelease.settings:name=Archiving", description="MBean to configure the release archiving service")
public class ArchivingSettingsManagerMBean {

    private ArchivingSettingsManager archivingSettingsManager;

    @Autowired
    public ArchivingSettingsManagerMBean(final ArchivingSettingsManager archivingSettingsManager) {
        this.archivingSettingsManager = archivingSettingsManager;
    }

    @ManagedAttribute(description = "Enabled pre-archiving")
    public boolean getPreArchivingEnabled() {
        return archivingSettingsManager.getPreArchivingEnabled();
    }

    @ManagedAttribute(description = "Enabled pre-archiving")
    public void setPreArchivingEnabled(boolean val) {
        archivingSettingsManager.setPreArchivingEnabled(val);
    }

    @ManagedAttribute(description = "Enable archiving")
    public boolean getEnabled() {
        return archivingSettingsManager.getEnabled();
    }

    @ManagedAttribute(description = "Enable archiving")
    public void setEnabled(boolean val) {
        archivingSettingsManager.setEnabled(val);
    }

    @ManagedAttribute(description = "Number of archivable releases to retrieve from the repository in a single search query")
    public int getSearchPageSize() {
        return archivingSettingsManager.getSearchPageSize();
    }

    @ManagedAttribute(description = "Number of archivable releases to retrieve from the repository in a single search query")
    public void setSearchPageSize(int val) {
        archivingSettingsManager.setSearchPageSize(val);
    }

    @ManagedAttribute(description = "Number of seconds that archiving is allowed to run before it is paused until the next time it is scheduled")
    public int getMaxSecondsPerRun() {
        return archivingSettingsManager.getMaxSecondsPerRun();
    }

    @ManagedAttribute(description = "Number of seconds that archiving is allowed to run before it is paused until the next time it is scheduled")
    public void setMaxSecondsPerRun(int val) {
        archivingSettingsManager.setMaxSecondsPerRun(val);
    }

    @ManagedAttribute(description = "Number of seconds to sleep between purging individual releases within a single run")
    public int getPurgingSleepSecondsBetweenReleases() {
        return archivingSettingsManager.getPurgingSleepSecondsBetweenReleases();
    }

    @ManagedAttribute(description = "Number of seconds to sleep between purging individual releases within a single run")
    public void setPurgingSleepSecondsBetweenReleases(int val) {
        archivingSettingsManager.setPurgingSleepSecondsBetweenReleases(val);
    }

    @ManagedAttribute(description = "Number of purging releases to retrieve from the repository in a single search query")
    public int getPurgingSearchPageSize() {
        return archivingSettingsManager.getPurgingSearchPageSize();
    }

    @ManagedAttribute(description = "Number of purging releases to retrieve from the repository in a single search query")
    public void setPurgingSearchPageSize(int val) {
        archivingSettingsManager.setPurgingSearchPageSize(val);
    }

    @ManagedAttribute(description = "Number of seconds that purging is allowed to run before it is paused until the next time it is scheduled")
    public int getPurgingMaxSecondsPerRun() {
        return archivingSettingsManager.getPurgingMaxSecondsPerRun();
    }

    @ManagedAttribute(description = "Number of seconds that purging is allowed to run before it is paused until the next time it is scheduled")
    public void setPurgingMaxSecondsPerRun(int val) {
        archivingSettingsManager.setPurgingMaxSecondsPerRun(val);
    }

    @ManagedAttribute(description = "Number of seconds to sleep between archiving individual releases within a single run")
    public int getSleepSecondsBetweenReleases() {
        return archivingSettingsManager.getSleepSecondsBetweenReleases();
    }

    @ManagedAttribute(description = "Number of seconds to sleep between archiving individual releases within a single run")
    public void setSleepSecondsBetweenReleases(int val) {
        archivingSettingsManager.setSleepSecondsBetweenReleases(val);
    }

    // Read only

    @ManagedAttribute(description = "Archiving job CRON schedule, configurable in deployit-defaults.properties")
    public String getJobCronSchedule() {
        return archivingSettingsManager.getArchivingJobCronSchedule();
    }

    @ManagedAttribute(description = "Archive completed releases older than (in hours, configurable in UI)")
    public Integer getReleaseAgeToDeleteFromJcr() {
        return archivingSettingsManager.getReleaseAgeToDeleteFromJcr();
    }

}
