package com.xebialabs.xlrelease.scheduler.domain

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.runner.JobRunner

import java.util
import scala.jdk.CollectionConverters._

@Metadata(label = "Local job runner", description = "This job runner is always present and should not be configurable", virtual = true)
object LocalJobRunner extends JobRunner {
  val DEFAULT_LOCAL_JOB_RUNNER_CAPABILITY: String = "local"

  override def getId(): String = "local"

  override def getCapabilities: util.Set[String] = Set[String](DEFAULT_LOCAL_JOB_RUNNER_CAPABILITY).asJava

  override def isEnabled: Boolean = true

  override def start(): Unit = {
    // nothing for now
  }

  override def stop(): Unit = {
    // nothing for now
  }

  override def delete(): Unit = {
    // nothing for now
  }

  override def abortJob(jobId: Long): Unit = {
    // nothing for now
  }

  override def capacity: Integer = XlrConfig.getInstance.executors.scheduler.maxThreadsCount

  override def isEncryptJobData(): Boolean = false
}
