package com.xebialabs.xlrelease.script.jython;

import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import com.xebialabs.xlrelease.script.ScriptVariables;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.service.ReleaseService;

import static com.xebialabs.xlrelease.domain.ScriptTask.JYTHON_ENGINE;

@Service
public class JythonScriptService extends DefaultScriptService {

    @Autowired
    public JythonScriptService(ScriptLifeCycle scriptLifeCycle,
                               JythonScriptExecutor jythonScriptExecutor,
                               AuthenticationService authenticationService,
                               ReleaseService releaseService,
                               ScriptVariables scriptVariables,
                               PermissionChecker permissions,
                               CommentService commentService,
                               XlrConfig xlrConfig,
                               AttachmentService attachmentService,
                               ConfigurationVariableService configurationVariableService) {
        super(scriptLifeCycle,
                jythonScriptExecutor,
                authenticationService,
                releaseService,
                scriptVariables,
                permissions,
                commentService,
                xlrConfig,
                attachmentService,
                configurationVariableService);
    }

    @Override
    public String engine() {
        return JYTHON_ENGINE;
    }

    @Override
    public boolean accepts(final String filename) {
        return "py".equals(FilenameUtils.getExtension(filename));
    }

}
