package com.xebialabs.xlrelease.security;


import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import org.springframework.stereotype.Component;

@Component
public class FacetPermissionChecker {
    private final AuthenticationService authenticationService;

    public FacetPermissionChecker(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void checkThatScriptTaskBelongsToReleaseOrOtherwise(String releaseId, Runnable otherwise) {
        if (authenticationService.isInScriptTask()) {
            if (!releaseId.equals(authenticationService.getCurrentScriptRelease().getId())) {
                try {
                    otherwise.run();
                } catch (Exception e) {
                    throw new PermissionDeniedException(String.format(
                        "The 'run automated tasks as user' property on the release " +
                            "is required to set facets on other releases than the current one. " +
                            "%s",
                        e.getMessage()), e);
                }
            }
        } else {
            otherwise.run();
        }
    }

    public boolean hasScriptTask() {
        return authenticationService.hasScriptTask();
    }

    public Task getScriptTask() {
        return authenticationService.getCurrentScriptTask();
    }
}
