package com.xebialabs.xlrelease.security.sql.snapshots.service

import com.xebialabs.xlrelease.security.sql.snapshots.domain.{ContainerTeamsAndRolesForPrincipalAndPermission, RolesSnapshot, RolesSnapshotUnavailableError}

import java.util.Date

trait PermissionsSnapshotService {

  def makeSnapshot(containerId: Option[String] = None): Unit

  def getMergedContainerSnapshotDataForReport(containerId: String, fromDate: Date, toDate: Date): (Seq[ContainerTeamsAndRolesForPrincipalAndPermission], Seq[RolesSnapshotUnavailableError])

  def findSnapshotsForRangeWithoutPermissionsCheck(containerId: Option[String], startDate: Date, endDate: Date): Seq[RolesSnapshot]
}
