package com.xebialabs.xlrelease.upgrade.settings

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry.getDescriptor
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.configuration.ExecutionLogPurgeSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging

class ExecutionLogPurgeSettingsInitializer(configurationRepository: ConfigurationRepository)
  extends BaseInitializingUpgrade
  with Logging {
  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "23.1.0#1")

  override def doUpgrade(): Boolean = {
    if (configurationRepository.exists(ExecutionLogPurgeSettings.EXECUTION_LOG_SETTINGS_ID)) {
      logger.debug("ExecutionLogPurgeSettings already exist in the database.")
    } else {
      val ci: ExecutionLogPurgeSettings = getDescriptor(Type.valueOf(classOf[ExecutionLogPurgeSettings]))
        .newInstance(ExecutionLogPurgeSettings.EXECUTION_LOG_SETTINGS_ID)
      configurationRepository.create(ci)
    }
    true
  }
}
