/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.container;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.ContainerTaskBuilder;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.domain.ContainerTask;
import com.xebialabs.xlrelease.domain.ContainerTaskDefinition;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.variable.VariableViewHelper;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.converters.BaseTaskViewConverter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Tuple2;

@Component
public class ContainerTaskViewConverter
extends BaseTaskViewConverter<ContainerTask> {
    private final ConfigurationRepository configurationRepository;

    @Autowired
    public ContainerTaskViewConverter(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    @Override
    protected Class<ContainerTask> getTaskClass() {
        return ContainerTask.class;
    }

    @Override
    protected ContainerTask fromView(TaskFullView view) {
        ContainerTask task = ((ContainerTaskBuilder)TaskBuilder.newContainerTask((String)view.getType()).withId(view.getId())).withStatusLine(view.getStatusLine()).withKeepPreviousOutputPropertiesOnRetry(view.isKeepPreviousOutputPropertiesOnRetry()).build();
        ContainerTaskDefinition containerTaskDefinition = new ContainerTaskDefinition(task.getType());
        this.fillProperties(view.getInputProperties(), containerTaskDefinition.getInputProperties(), task);
        this.fillProperties(view.getOutputProperties(), containerTaskDefinition.getOutputProperties(), task);
        task.setConfigurationUri(view.getConfigurationUri());
        return task;
    }

    @Override
    public TaskFullView toFullView(ContainerTask task, List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView taskFullView = super.toFullView(task, allowedTaskTypesForAuthenticatedUser);
        Map variableMapping = task.getVariableMapping();
        task.getTaskType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> "input".equals(pd.getCategory())).forEach(pd -> taskFullView.getInputProperties().put(pd.getName(), this.viewValue((PropertyDescriptor)pd, task, variableMapping, false)));
        task.getTaskType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> "output".equals(pd.getCategory())).forEach(pd -> taskFullView.getOutputProperties().put(pd.getName(), this.viewValue((PropertyDescriptor)pd, task, variableMapping, true)));
        taskFullView.setOutputVarHelpText(task.getOutputVarHelpText());
        taskFullView.setColor(task.getTaskColor());
        taskFullView.setCustomIconClass(task.getIconClass());
        taskFullView.setCustomIconLocation(task.getIconLocation());
        taskFullView.setScriptDefinitionType(task.getType().toString());
        taskFullView.setConfigurationUri(task.getConfigurationUri());
        taskFullView.setStatusLine(task.getStatusLine());
        taskFullView.setKeepPreviousOutputPropertiesOnRetry(task.isKeepPreviousOutputPropertiesOnRetry());
        taskFullView.setContainerTask(true);
        return taskFullView;
    }

    private Object viewValue(PropertyDescriptor pd, ContainerTask task, Map<String, String> variableMapping, boolean useViewForStrings) {
        String propertyName = pd.getName();
        return VariableViewHelper.toView(pd, variableMapping.get(propertyName), task.getProperty(propertyName), useViewForStrings);
    }

    private void fillProperties(Map<String, Object> viewProperties, Collection<PropertyDescriptor> propertyDescriptors, ContainerTask containerTask) {
        propertyDescriptors.forEach(pd -> {
            String propertyName = pd.getName();
            Object viewValue = viewProperties.get(propertyName);
            if (viewValue == null) {
                containerTask.setProperty(propertyName, null);
            } else {
                Tuple2<String, Object> variableAndValue = VariableViewHelper.fromView(pd, viewValue, this.configurationRepository);
                String variable = (String)variableAndValue._1();
                AbstractCollection value = variableAndValue._2();
                if (value != null) {
                    switch (pd.getKind()) {
                        case SET_OF_STRING: 
                        case SET_OF_CI: {
                            value = new HashSet(value);
                            break;
                        }
                        case LIST_OF_CI: 
                        case LIST_OF_STRING: {
                            value = new ArrayList(value);
                            break;
                        }
                    }
                }
                containerTask.setProperty(propertyName, (Object)value);
                this.updateVariableMappingOfProperty(containerTask, propertyName, variable);
            }
        });
    }

    @Override
    protected void fillVariableMappings(TaskFullView view, ContainerTask task) {
    }

    private void updateVariableMappingOfProperty(ContainerTask containerTask, String propertyName, String variableName) {
        Map variableMapping = containerTask.getVariableMapping();
        if (Strings.isNotEmpty((String)variableName)) {
            variableMapping.put(propertyName, variableName);
        } else {
            variableMapping.remove(propertyName);
        }
    }
}

