/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import akka.actor.Address;
import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobRow$;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.converters.TaskJobConverter;
import com.xebialabs.xlrelease.scheduler.domain.LocalJobRunner$;
import com.xebialabs.xlrelease.scheduler.events.JobCreatedEvent;
import com.xebialabs.xlrelease.scheduler.events.JobFinishedEvent;
import com.xebialabs.xlrelease.scheduler.events.JobReservedEvent;
import com.xebialabs.xlrelease.scheduler.repository.ConfirmJobExecution;
import com.xebialabs.xlrelease.scheduler.repository.DeleteById;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.scheduler.repository.ReserveJob;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.service.BroadcastService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.slf4j.Marker;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@ScalaSignature(bytes="\u0006\u0005\t=d\u0001\u0002\u0011\"\u0001)B\u0001\"\u0010\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u007f!Aa\t\u0001BC\u0002\u0013\u0005q\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003I\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\u0002\u0003,\u0001\u0005\u000b\u0007I\u0011A,\t\u0011y\u0003!\u0011!Q\u0001\naCQa\u0018\u0001\u0005\u0002\u0001Dqa\u001d\u0001C\u0002\u0013%A\u000fC\u0004\u0002\u0006\u0001\u0001\u000b\u0011B;\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\f\u0001\u0001\u0006I!a\u0003\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA!\u0001\u0011\u0005\u00111\t\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Ba!!\u0017\u0001\t\u0003!\bbBA.\u0001\u0011\u0005\u0011Q\f\u0005\n\u0003w\u0002\u0011\u0013!C\u0001\u0003{Bq!!%\u0001\t\u0003\t\u0019\nC\u0004\u0002v\u0002!\t!a>\t\u000f\u0005u\b\u0001\"\u0001\u0002\u0000\"9!\u0011\u0001\u0001\u0005\u0002\u0005}\bb\u0002B\u0002\u0001\u0011\u0005!Q\u0001\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0011\u001d\u00119\u0002\u0001C\u0001\u0005;AqA!\t\u0001\t\u0003\u0011\u0019\u0003C\u0004\u0003,\u0001!IA!\f\t\u000f\tU\u0002\u0001\"\u0003\u00038!9!\u0011\n\u0001\u0005\n\t-#a\u0004#fM\u0006,H\u000e\u001e&pEF+X-^3\u000b\u0005\t\u001a\u0013!C:dQ\u0016$W\u000f\\3s\u0015\t!S%A\u0005yYJ,G.Z1tK*\u0011aeJ\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001K\u0001\u0004G>l7\u0001A\n\u0005\u0001-\n\u0014\b\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0004B]f\u0014VM\u001a\t\u0003e]j\u0011a\r\u0006\u0003iU\nQa\u001d7gi)T\u0011AN\u0001\tOJL'P\u001f7fI&\u0011\u0001h\r\u0002\b\u0019><w-\u001b8h!\tQ4(D\u0001\"\u0013\ta\u0014E\u0001\u0004O_\u0012,\u0017\nZ\u0001\u0011i\u0006\u001c8NS8c\u0007>tg/\u001a:uKJ,\u0012a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u0006\n!bY8om\u0016\u0014H/\u001a:t\u0013\t!\u0015I\u0001\tUCN\\'j\u001c2D_:4XM\u001d;fe\u0006\tB/Y:l\u0015>\u00147i\u001c8wKJ$XM\u001d\u0011\u0002\u001b)|'MU3q_NLGo\u001c:z+\u0005A\u0005CA%M\u001b\u0005Q%BA&\"\u0003)\u0011X\r]8tSR|'/_\u0005\u0003\u001b*\u0013QBS8c%\u0016\u0004xn]5u_JL\u0018A\u00046pEJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0011EJ|\u0017\rZ2bgR\u001cVM\u001d<jG\u0016\u0004\"!\u0015+\u000e\u0003IS!aU\u0012\u0002\u000fM,'O^5dK&\u0011QK\u0015\u0002\u0011\u0005J|\u0017\rZ2bgR\u001cVM\u001d<jG\u0016\f\u0011#Y2u_J\u001c\u0016p\u001d;f[\"{G\u000eZ3s+\u0005A\u0006CA-]\u001b\u0005Q&BA.$\u0003\u0019\t7\r^8sg&\u0011QL\u0017\u0002\u0012\u0003\u000e$xN]*zgR,W\u000eS8mI\u0016\u0014\u0018AE1di>\u00148+_:uK6Du\u000e\u001c3fe\u0002\na\u0001P5oSRtD#B1cG\u0012,\u0007C\u0001\u001e\u0001\u0011\u0015i\u0004\u00021\u0001@\u0011\u00151\u0005\u00021\u0001I\u0011\u0015y\u0005\u00021\u0001Q\u0011\u00151\u0006\u00021\u0001YQ\t)w\r\u0005\u0002ic6\t\u0011N\u0003\u0002kW\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u00051l\u0017aB2p]R,\u0007\u0010\u001e\u0006\u0003]>\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002a\u0006\u0019qN]4\n\u0005IL'\u0001\u0002'buf\f!b\u00187pG\u0006d'j\u001c2t+\u0005)\bc\u0001<~\u007f6\tqO\u0003\u0002ys\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005i\\\u0018\u0001B;uS2T\u0011\u0001`\u0001\u0005U\u00064\u0018-\u0003\u0002\u007fo\nQA)\u001a7bsF+X-^3\u0011\u0007i\n\t!C\u0002\u0002\u0004\u0005\u00121AS8c\u0003-yFn\\2bY*{'m\u001d\u0011\u0002\u0015}K7OU;o]&tw-\u0006\u0002\u0002\fA!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012]\fa!\u0019;p[&\u001c\u0017\u0002BA\u000b\u0003\u001f\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aC0jgJ+hN\\5oO\u0002\naa];c[&$H\u0003BA\u000f\u0003G\u00012\u0001LA\u0010\u0013\r\t\t#\f\u0002\u0005+:LG\u000f\u0003\u0004\u0002&5\u0001\ra`\u0001\u0004U>\u0014\u0007fA\u0007\u0002*A!\u00111FA\u001c\u001b\t\tiCC\u0002k\u0003_QA!!\r\u00024\u00059Q.\u001a;sS\u000e\u001c(bAA\u001bO\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002:\u00055\"!\u0002+j[\u0016$\u0017AD:vE6LG/\u0012=jgRLgn\u001a\u000b\u0005\u0003;\ty\u0004\u0003\u0004\u0002&9\u0001\ra`\u0001\u0012gV\u0014W.\u001b;Ce>\fGmY1ti\u0016$G\u0003BA\u000f\u0003\u000bBa!!\n\u0010\u0001\u0004y\u0018a\u0002:fa2\f7-\u001a\u000b\u0005\u0003;\tY\u0005\u0003\u0004\u0002&A\u0001\ra \u0015\u0004!\u0005%\u0012!C5t%Vtg.\u001b8h)\t\t\u0019\u0006E\u0002-\u0003+J1!a\u0016.\u0005\u001d\u0011un\u001c7fC:\f\u0011\u0002\\8dC2TuNY:\u0002\u000fI,7/\u001a:wKR)q0a\u0018\u0002b!1\u0011QE\nA\u0002}D\u0011\"a\u0019\u0014!\u0003\u0005\r!!\u001a\u0002\u0011I,hN\\3s\u0013\u0012\u0004B!a\u001a\u0002v9!\u0011\u0011NA9!\r\tY'L\u0007\u0003\u0003[R1!a\u001c*\u0003\u0019a$o\\8u}%\u0019\u00111O\u0017\u0002\rA\u0013X\rZ3g\u0013\u0011\t9(!\u001f\u0003\rM#(/\u001b8h\u0015\r\t\u0019(L\u0001\u0012e\u0016\u001cXM\u001d<fI\u0011,g-Y;mi\u0012\u0012TCAA@U\u0011\t)'!!,\u0005\u0005\r\u0005\u0003BAC\u0003\u001bk!!a\"\u000b\t\u0005%\u00151R\u0001\nk:\u001c\u0007.Z2lK\u0012T!A[\u0017\n\t\u0005=\u0015q\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aB2p]\u001aL'/\u001c\u000b\u0007\u0003+\u000by,a;\u0011\u000f1\n9*a\u0015\u0002\u001c&\u0019\u0011\u0011T\u0017\u0003\rQ+\b\u000f\\33!\u0015a\u0013QTAQ\u0013\r\ty*\f\u0002\u0007\u001fB$\u0018n\u001c81\t\u0005\r\u0016Q\u0016\t\u0006u\u0005\u0015\u0016\u0011V\u0005\u0004\u0003O\u000b#a\u0002+bg.TuN\u0019\t\u0005\u0003W\u000bi\u000b\u0004\u0001\u0005\u0017\u0005=V#!A\u0001\u0002\u000b\u0005\u0011\u0011\u0017\u0002\u0004?\u0012\n\u0014\u0003BAZ\u0003s\u00032\u0001LA[\u0013\r\t9,\f\u0002\b\u001d>$\b.\u001b8h!\ra\u00131X\u0005\u0004\u0003{k#aA!os\"9\u00111M\u000bA\u0002\u0005\u0005\u0007\u0003BAb\u0003KtA!!2\u0002`:!\u0011qYAm\u001d\u0011\tI-!6\u000f\t\u0005-\u00171\u001b\b\u0005\u0003\u001b\f\tN\u0004\u0003\u0002l\u0005=\u0017\"\u0001\u0015\n\u0005\u0019:\u0013B\u0001\u0013&\u0013\r\t9nI\u0001\u0007eVtg.\u001a:\n\t\u0005m\u0017Q\\\u0001\u0007I>l\u0017-\u001b8\u000b\u0007\u0005]7%\u0003\u0003\u0002b\u0006\r\u0018a\u00029bG.\fw-\u001a\u0006\u0005\u00037\fi.\u0003\u0003\u0002h\u0006%(\u0001\u0003*v]:,'/\u00133\u000b\t\u0005\u0005\u00181\u001d\u0005\b\u0003[,\u0002\u0019AAx\u0003\u0015QwNY%e!\u0011\t\u0019-!=\n\t\u0005M\u0018\u0011\u001e\u0002\u0006\u0015>\u0014\u0017\nZ\u0001\u0007M&t\u0017n\u001d5\u0015\t\u0005u\u0011\u0011 \u0005\b\u0003[4\u0002\u0019AAxQ\r1\u0012\u0011F\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003;\tAa\u001d;pa\u0006A1-\u00198dK2Le\r\u0006\u0003\u0002\u001e\t\u001d\u0001b\u0002B\u00053\u0001\u0007!1B\u0001\naJ,G-[2bi\u0016\u0004RA!\u0004\u0003\u0014}l!Aa\u0004\u000b\u0007\tE\u00110\u0001\u0005gk:\u001cG/[8o\u0013\u0011\u0011)Ba\u0004\u0003\u0013A\u0013X\rZ5dCR,\u0017!\u0003:f[>4XMS8c)\u0011\tiBa\u0007\t\r\u0005\u0015\"\u00041\u0001\u0000)\u0011\tiBa\b\t\u000f\u000558\u00041\u0001\u0002p\u0006!1/\u001b>f)\t\u0011)\u0003E\u0002-\u0005OI1A!\u000b.\u0005\rIe\u000e^\u0001\u000fC\u0012$Gk\u001c'pG\u0006d'j\u001c2t)\u0019\tiBa\f\u00032!1\u0011QE\u000fA\u0002}DqAa\r\u001e\u0001\u0004\t\u0019&\u0001\u0007ce>\fGmY1ti*{'-A\u0002m_\u001e$BA!\u000f\u0003FQ!\u0011Q\u0004B\u001e\u0011!\u0011iD\bCA\u0002\t}\u0012!\u00022m_\u000e\\\u0007#\u0002\u0017\u0003B\u0005u\u0011b\u0001B\"[\tAAHY=oC6,g\bC\u0004\u0003Hy\u0001\r!!\u001a\u0002\rA\u0014XMZ5y\u00035awnY1m\u0015>\u00147oU5{KR\u0011\u0011Q\r\u0015\u0004\u0001\t=\u0003\u0003\u0002B)\u0005/j!Aa\u0015\u000b\u0007\tUS.\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAA!\u0017\u0003T\tI1i\\7q_:,g\u000e\u001e\u0015\b\u0001\tu#1\rB3!\rA'qL\u0005\u0004\u0005CJ'!B*d_B,\u0017!\u00039s_bLXj\u001c3fI\t\u00119'\u0003\u0003\u0003j\t-\u0014\u0001\u0004+B%\u001e+EkX\"M\u0003N\u001b&b\u0001B7S\u0006y1kY8qK\u0012\u0004&o\u001c=z\u001b>$W\r")
public class DefaultJobQueue
implements Logging,
NodeId {
    private final TaskJobConverter taskJobConverter;
    private final JobRepository jobRepository;
    private final BroadcastService broadcastService;
    private final ActorSystemHolder actorSystemHolder;
    private final DelayQueue<Job> _localJobs;
    private final AtomicBoolean _isRunning;
    private String nodeId;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    @Override
    public String convertAddressToNodeId(Address address) {
        return NodeId.convertAddressToNodeId$(this, address);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private String nodeId$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$0) {
                this.nodeId = NodeId.nodeId$(this);
                this.bitmap$0 = true;
            }
        }
        return this.nodeId;
    }

    @Override
    public String nodeId() {
        if (!this.bitmap$0) {
            return this.nodeId$lzycompute();
        }
        return this.nodeId;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public TaskJobConverter taskJobConverter() {
        return this.taskJobConverter;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    private DelayQueue<Job> _localJobs() {
        return this._localJobs;
    }

    private AtomicBoolean _isRunning() {
        return this._isRunning;
    }

    @Timed
    public void submit(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "submitted job " + job);
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            JobRow qual$1 = JobRow$.MODULE$.apply(taskJob);
            String x$1 = this.nodeId();
            long x$2 = qual$1.copy$default$1();
            JobType x$3 = qual$1.copy$default$3();
            JobStatus x$4 = qual$1.copy$default$4();
            long x$5 = qual$1.copy$default$5();
            Instant x$6 = qual$1.copy$default$6();
            Instant x$7 = qual$1.copy$default$7();
            Instant x$8 = qual$1.copy$default$8();
            Instant x$9 = qual$1.copy$default$9();
            String x$10 = qual$1.copy$default$10();
            Integer x$11 = qual$1.copy$default$11();
            String x$12 = qual$1.copy$default$12();
            String x$13 = qual$1.copy$default$13();
            taskJob.setId(this.jobRepository().create(qual$1.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13)).id());
        }
        this.addToLocalJobs(job, job.broadcast());
    }

    public void submitExisting(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "submitted existing job " + job);
        this.removeJob(job);
        this.addToLocalJobs(job, job.broadcast());
    }

    public void submitBroadcasted(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "submitted broadcasted job " + job);
        this.removeJob(job);
        this.addToLocalJobs(job, false);
    }

    @Timed
    public void replace(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "replaced job " + job);
        JobRow qual$1 = JobRow$.MODULE$.apply(job);
        String x$1 = this.nodeId();
        Object x$2 = null;
        long x$3 = qual$1.copy$default$1();
        JobType x$4 = qual$1.copy$default$3();
        JobStatus x$5 = qual$1.copy$default$4();
        long x$6 = qual$1.copy$default$5();
        Instant x$7 = qual$1.copy$default$6();
        Instant x$8 = qual$1.copy$default$7();
        Instant x$9 = qual$1.copy$default$8();
        Instant x$10 = qual$1.copy$default$9();
        String x$11 = qual$1.copy$default$10();
        Integer x$12 = qual$1.copy$default$11();
        String x$13 = qual$1.copy$default$12();
        long newJobId = this.jobRepository().replace(qual$1.copy(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, null)).id();
        this.removeJob(job);
        job.setId(newJobId);
        this.addToLocalJobs(job, false);
    }

    public boolean isRunning() {
        return this._isRunning().get();
    }

    public DelayQueue<Job> localJobs() {
        return this._localJobs();
    }

    public Job reserve(Job job, String runnerId) {
        Try<JobRow> lockAttempt = this.jobRepository().update(new ReserveJob(JobRow$.MODULE$.apply(job), this.nodeId(), runnerId));
        Try<JobRow> try_ = lockAttempt;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw exception;
        }
        if (try_ instanceof Success) {
            TaskJob<?> taskJob;
            Success success = (Success)try_;
            JobRow row = (JobRow)success.value();
            Job job2 = job;
            if (job2 instanceof TaskJob) {
                TaskJob taskJob2 = (TaskJob)job2;
                taskJob = this.taskJobConverter().fromJobRow(row, (Option<TaskSoftReference<? extends Task>>)new Some(taskJob2.taskRef()));
            } else {
                taskJob = this.taskJobConverter().fromJobRow(row, this.taskJobConverter().fromJobRow$default$2());
            }
            TaskJob<?> lockedJob = taskJob;
            this.broadcastService.broadcast(new JobReservedEvent(lockedJob.id()), false);
            this.removeJob(job);
            return lockedJob;
        }
        throw new MatchError(try_);
    }

    public String reserve$default$2() {
        return LocalJobRunner$.MODULE$.getId();
    }

    public Tuple2<Object, Option<TaskJob<?>>> confirm(String runnerId, long jobId) {
        Try confirmationResult = Try$.MODULE$.apply((Function0 & Serializable)() -> (JobRow)this.jobRepository().read(jobId).get()).flatMap((Function1 & Serializable)jobRow -> this.jobRepository().update(new ConfirmJobExecution((JobRow)jobRow, runnerId)).map((Function1 & Serializable)confirmedRow -> confirmedRow));
        Try try_ = confirmationResult;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Unable to confirm job " + jobId, (Function0 & Serializable)() -> ex);
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)None$.MODULE$);
        }
        if (try_ instanceof Success) {
            None$ none$;
            Success success = (Success)try_;
            JobRow row = (JobRow)success.value();
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> this.taskJobConverter().fromJobRow(row, this.taskJobConverter().fromJobRow$default$2()));
            if (try_2 instanceof Failure) {
                none$ = None$.MODULE$;
            } else if (try_2 instanceof Success) {
                Success success2 = (Success)try_2;
                TaskJob value = (TaskJob)success2.value();
                none$ = Option$.MODULE$.apply((Object)value);
            } else {
                throw new MatchError((Object)try_2);
            }
            None$ maybeJob = none$;
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)maybeJob);
        }
        throw new MatchError((Object)try_);
    }

    @Timed
    public void finish(long jobId) {
        this.logger().debug((Function0 & Serializable)() -> "finishing job " + jobId);
        this.removeJob(jobId);
        this.jobRepository().read(jobId).foreach((Function1 & Serializable)job -> {
            DefaultJobQueue.$anonfun$finish$2(this, job);
            return BoxedUnit.UNIT;
        });
    }

    public void start() {
        this.logger().debug((Function0 & Serializable)() -> "starting job queue");
        this._isRunning().set(true);
    }

    public void stop() {
        this.logger().debug((Function0 & Serializable)() -> "stopping job queue");
        this._isRunning().set(false);
    }

    public void cancelIf(Predicate<Job> predicate) {
        this.log("cancelIf", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.localJobs().removeIf(predicate));
    }

    public void removeJob(Job job) {
        this.log("removeJob", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.localJobs().remove(job));
    }

    public void removeJob(long jobId) {
        this.log("removeJob by id", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.localJobs().removeIf(x$1 -> x$1.id() == jobId));
    }

    public int size() {
        return this.localJobs().size();
    }

    private void addToLocalJobs(Job job, boolean broadcastJob) {
        this.log("addToLocalJobs", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (this.localJobs().contains(job) && !(job instanceof StopWorkerThread)) {
                IllegalStateException ex = new IllegalStateException("Queue already contains job " + job);
                this.logger().error((Function0 & Serializable)() -> "Please report an error.", (Function0 & Serializable)() -> ex);
            }
            this.localJobs().add(job);
            if (broadcastJob) {
                $this.broadcastService.broadcast(new JobCreatedEvent(job), false);
                return;
            }
        });
    }

    private void log(String prefix, Function0<BoxedUnit> block) {
        this.logger().trace((Function0 & Serializable)() -> prefix + ": before " + this.localJobsSize());
        try {
            block.apply$mcV$sp();
        }
        finally {
            this.logger().trace((Function0 & Serializable)() -> prefix + ": after: " + this.localJobsSize());
        }
    }

    private String localJobsSize() {
        return this.size() + ": " + CollectionConverters$.MODULE$.IteratorHasAsScala(this.localJobs().iterator()).asScala().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.id())).mkString(",");
    }

    public static final /* synthetic */ void $anonfun$finish$2(DefaultJobQueue $this, JobRow job) {
        $this.jobRepository().delete(new DeleteById(job.id()));
        $this.broadcastService.broadcast(new JobFinishedEvent(job.executionId(), job.id()), true);
    }

    public DefaultJobQueue(TaskJobConverter taskJobConverter, JobRepository jobRepository, BroadcastService broadcastService, @Lazy ActorSystemHolder actorSystemHolder) {
        this.taskJobConverter = taskJobConverter;
        this.jobRepository = jobRepository;
        this.broadcastService = broadcastService;
        this.actorSystemHolder = actorSystemHolder;
        Logging.$init$((Logging)this);
        NodeId.$init$(this);
        this._localJobs = new DelayQueue();
        this._isRunning = new AtomicBoolean(true);
    }
}

