/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.TaskViewConverter;
import com.xebialabs.xlrelease.views.TaskFullView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TasksViewConverter {
    private Map<Type, TaskViewConverter> taskViewConverters = new HashMap<Type, TaskViewConverter>();

    @Autowired
    public void setTaskViewConverters(List<? extends TaskViewConverter> taskViewConverters) {
        taskViewConverters.forEach(converter -> this.taskViewConverters.put(converter.getTaskType(), (TaskViewConverter)converter));
    }

    public TaskFullView toFullView(Task task, List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskViewConverter taskViewConverter = this.getConverterFor(task.getType());
        return taskViewConverter.toFullView(task, allowedTaskTypesForAuthenticatedUser);
    }

    public List<TaskFullView> toFullView(Collection<? extends Task> tasks, List<Type> allowedTaskTypesForAuthenticatedUser) {
        return tasks.stream().map(t -> this.toFullView((Task)t, allowedTaskTypesForAuthenticatedUser)).collect(Collectors.toList());
    }

    public Task toTask(TaskFullView view) {
        return this.getConverterFor(Type.valueOf((String)view.getType())).toTask(view);
    }

    private TaskViewConverter getConverterFor(Type taskType) {
        TaskViewConverter taskViewConverter = this.findConverterFor(taskType);
        if (null == taskViewConverter) {
            throw new IllegalStateException(String.format("TaskFullViewConverter is not defined for task '%s'", taskType));
        }
        return taskViewConverter;
    }

    private TaskViewConverter findConverterFor(Type taskType) {
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        typeHierarchy.add(taskType);
        typeHierarchy.addAll(taskType.getDescriptor().getSuperClasses());
        Optional<TaskViewConverter> r = typeHierarchy.stream().map(t -> this.taskViewConverters.get(t)).filter(Objects::nonNull).findFirst();
        return r.orElse(null);
    }
}

