package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;
import com.google.common.annotations.VisibleForTesting;

import com.xebialabs.xlrelease.domain.TaskDefinition;
import com.xebialabs.xltype.serialization.json.JsonWriter;

import static com.xebialabs.deployit.plumbing.AbstractConfigurationItemReaderWriter.getClassFromGenericType;
import static java.nio.charset.StandardCharsets.UTF_8;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON})
public class TaskDefinitionsJsonWriter implements MessageBodyWriter<Collection<TaskDefinition>> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = getClassFromGenericType(genericType);
        }
        return TaskDefinition.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(Collection<TaskDefinition> objects, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1;
    }

    @Override
    public void writeTo(Collection<TaskDefinition> objects, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(objects).getBytes(UTF_8));
    }

    @VisibleForTesting
    String toJson(Collection<TaskDefinition> objects) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        writer.array();

        for (TaskDefinition object : objects) {
            TaskDefinitionJsonWriter.writeObject(writer, object);
        }

        writer.endArray();
        return stringWriter.toString();
    }
}
