package com.xebialabs.xlrelease.actors

import akka.actor.ExtendedActorSystem
import com.esotericsoftware.kryo.Kryo
import com.xebialabs.xlrelease.support.akka.spring.ScalaSpringAwareBean
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

// mechanism so we can register custom serializers from other spring modules
abstract class KryoInitializers extends ScalaSpringAwareBean with KryoInitializer with Logging {
  @Autowired(required = false)
  private var kryoInitializers: Array[KryoInitializer] = _

  override def postInit(kryo: Kryo, system: ExtendedActorSystem): Unit = {
    if (null != kryoInitializers) {
      kryoInitializers.sortBy(_.getOrder).foreach(_.postInit(kryo, system))
    }
  }
}


object KryoInitializers extends KryoInitializers {
  override def getOrder: Int = 0
}