package com.xebialabs.xlrelease.api.internal

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.api.internal.FolderVariablesDecorator.FOLDER_VARIABLES
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.domain.variables.FolderVariables
import com.xebialabs.xlrelease.repository.FolderVariableRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util
import scala.collection.mutable
import scala.jdk.CollectionConverters._

object FolderVariablesDecorator {
  val FOLDER_VARIABLES = "folderVariables"
}

@Component
class FolderVariablesDecorator @Autowired()(folderVariableRepository: FolderVariableRepository) extends CachedInternalMetadataDecorator[Folder, mutable.Map[String, FolderVariables]] {

  override val name: String = FOLDER_VARIABLES

  override def isApplicableTo(ci: ConfigurationItem): Boolean = ci.isInstanceOf[Folder]

  override def decorate(cis: util.Collection[Folder], cache: DecoratorCache[mutable.Map[String, FolderVariables]]): Unit = {
    val cached = cache.computeIfAbsent(() => mutable.Map[String, FolderVariables]())
    cis.asScala.foreach { folder =>
      if (!cached.contains(folder.getId)) {
        cached.put(folder.getId, new FolderVariables(folder.getId, folderVariableRepository.getAllFromAncestry(folder.getId)))
      }
      folder.get$metadata().put(FOLDER_VARIABLES, cached(folder.getId))
    }
  }
}
