package com.xebialabs.xlrelease.api.internal;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.SseEventSink;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.xlrelease.service.SseService;

@Path("/sse")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@Controller
public class SseResource {

    private SseService sseService;

    @Autowired
    public SseResource(SseService sseService) {
        this.sseService = sseService;
    }

    @GET
    @Produces(MediaType.SERVER_SENT_EVENTS)
    public void subscribeToNotifications(@Context SseEventSink sink) {
        this.sseService.subscribeUserToSink(sink);
    }
}
