package com.xebialabs.xlrelease.api.utils;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;

import static java.lang.String.format;

public class ResponseHelper {

    // IMPORTANT: do not use @Workdir annotation on a method that returns StreamingOutput, as it will clear context before StreamingOutput.write
    //  method is invoked. This is most likely not what you want as you will use more than one WorkdirContext.
    public static Response streamFile(String fileName, StreamingOutput output, String contentType) {
        return Response.ok(output, contentType)
                .header("Content-Disposition", format("attachment; filename=\"%s\"", fileName)).build();
    }
}
