package com.xebialabs.xlrelease.authentication

import org.springframework.context.annotation.Configuration
import org.springframework.security.core.userdetails.{UserDetails, UserDetailsService, UsernameNotFoundException}

import java.util
import scala.jdk.CollectionConverters._

@Configuration
class DelegatingUserDetailsService(val userDetailsServices: util.Collection[UserDetailsService]) extends UserDetailsService {

  @throws[UsernameNotFoundException]
  override def loadUserByUsername(username: String): UserDetails = {
    var last: RuntimeException = null
    for (uds <- userDetailsServices.asScala) {
      try
        return uds.loadUserByUsername(username)
      catch {
        case error: RuntimeException =>
          last = error
      }
    }
    throw last
  }
}
