package com.xebialabs.xlrelease.cache.caffeine

import com.github.benmanes.caffeine.cache.Cache

import java.util
import scala.jdk.CollectionConverters._


class CaffeineStatsCounter(cache: Cache[_, _]) extends DelegatedStatsCounterMBean {
  override def getCacheSize: Long = cache.estimatedSize()

  override def getCacheHits: Long = cache.stats().hitCount()

  override def getCacheHitPercentage: Float = cache.stats().hitRate().toFloat

  override def getCacheMisses: Long = cache.stats().missCount()

  override def getCacheMissPercentage: Float = cache.stats().missRate().toFloat

  override def getCacheGets: Long = cache.stats().requestCount()

  override def getCacheEvictions: Long = cache.stats().evictionCount()

  override def keys: util.Set[String] = cache.asMap().keySet().asScala.map(_.toString).asJava

}

