package com.xebialabs.xlrelease.features.distributed

import com.xebialabs.xlrelease.features.{DatabaseProxyFeature, JobSchedulerFeature, PluginDevelopmentFeature, ReleaseLoadingFeature}
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class DistributedFeaturesConfiguration {
  // this config exist only so it would register scala objects as spring beans

  @Bean
  def jobSchedulerFeature: JobSchedulerFeature = JobSchedulerFeature

  @Bean
  def dependencyLoadingFeature: ReleaseLoadingFeature = ReleaseLoadingFeature

  @Bean
  def databaseProxyFeature: DatabaseProxyFeature = DatabaseProxyFeature

  @Bean
  def pluginDevelopmentFeature: PluginDevelopmentFeature = PluginDevelopmentFeature
}
