package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Plugin development",
  description = "Flags to control server instance used for development purpose"
)
class PluginDevelopmentFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(defaultValue = "Incubating",
    isTransient = true,
    hidden = true,
    readonly = true)
  var category: String = _

  @BeanProperty
  @XLProperty(label = "Reload jython modules",
    description = "Enable reload of jython modules when plugin is installed. Do not enable it in production.",
    category = "input",
    defaultValue = "false")
  var enableJythonModuleReload: Boolean = _
}
