package com.xebialabs.xlrelease.initialize;

import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.server.api.upgrade.RepositoryInitialization;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.export.TemplateImporter;
import com.xebialabs.xlrelease.template.SamplesImporter;

import static com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT;

@Component
public class SampleTemplatesInitialization implements RepositoryInitialization, SamplesImporter {
    private static final Logger logger = LoggerFactory.getLogger(SampleTemplatesInitialization.class);

    public static final String TEMPLATE_WELCOME_ID = "Applications/ReleaseTemplate_welcome";
    public static final String TEMPLATE_CONFIGURE_ID = "Applications/ReleaseTemplate_configure";
    public static final String TEMPLATE_TOUR_ID = "Applications/ReleaseTemplate_tour";
    public static final String TEMPLATE_SAMPLE_ID = "Applications/ReleaseTemplate_sample";
    public static final String TEMPLATE_SAMPLE_WITH_XLD_ID = "Applications/ReleaseTemplate_sample_with_Deployit";
    public static final String TEMPLATE_BLUE_GREEN_ID = "Applications/ReleaseTemplate_blue_green_deployment";
    public static final String TEMPLATE_CANARY_ID = "Applications/ReleaseTemplate_canary_deployment";

    public static final String FOLDER_TEMPLATE_WELCOME_ID = "Applications/FolderSamplesAndTutorials/ReleaseTemplate_welcome";
    public static final String FOLDER_TEMPLATE_CONFIGURE_ID = "Applications/FolderSamplesAndTutorials/ReleaseTemplate_configure";

    private TemplateImporter templateImporter;
    private XlrConfig xlrConfig;
    private WorkDirContext workDirContext;

    private Map<String, String> sampleTemplates = new LinkedHashMap<String, String>() {{
        put("templates/welcome.json", TEMPLATE_WELCOME_ID);
        put("templates/configure.json", TEMPLATE_CONFIGURE_ID);
        put("templates/tour.json", TEMPLATE_TOUR_ID);
        put("templates/sample.json", TEMPLATE_SAMPLE_ID);
        put("templates/blue-green.json", TEMPLATE_BLUE_GREEN_ID);
        put("templates/sample-with-xl-deploy.json", TEMPLATE_SAMPLE_WITH_XLD_ID);
        put("templates/canary.json", TEMPLATE_CANARY_ID);
    }};

    @Autowired
    public SampleTemplatesInitialization(TemplateImporter templateImporter,
                                         XlrConfig xlrConfig, WorkDirContext workDirContext) {
        this.templateImporter = templateImporter;
        this.workDirContext= workDirContext;
        this.xlrConfig = xlrConfig;
    }

    @Override
    public WorkDirContext workDirContext() {
        return this.workDirContext;
    }

    @Override
    public TemplateImporter templateImporter() {
        return this.templateImporter;
    }

    @Override
    public void doInitialize() {
        if (xlrConfig.initialization_createSampleTemplates()) {
            logger.info("Importing sample templates");
            importSampleTemplates(sampleTemplates);
        } else {
            logger.info("Skipping import of sample templates");
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getComponent() {
        return XL_RELEASE_COMPONENT;
    }
}
