package com.xebialabs.xlrelease.serialization.domain;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.serialization.json.jackson.PasswordDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.PasswordSerializer;

public abstract class PasswordStringVariableJsonMixin {

    /**
     * Marks the {@link com.xebialabs.xlrelease.domain.variables.PasswordStringVariable#value}
     * field to be serialized as a password.
     */
    @SuppressWarnings("unused")
    @JsonSerialize(using = PasswordSerializer.class)
    @JsonDeserialize(using = PasswordDeserializer.class)
    private String value;

}
