package com.xebialabs.xlrelease.server.jetty;

import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.xlrelease.config.XlrConfig;

@Configuration
public class CustomJettyConfiguration {

    @Bean
    public JettyServer jettyServer(final ServerConfiguration serverConfiguration,
                                   final XlrConfig xlrConfig) {
        return new JettyServer(serverConfiguration, xlrConfig);
    }

    @Bean
    public JettyServletWebServerFactory jettyServletWebServerFactory(ObjectProvider<JettyServerCustomizer> jettyServerCustomizers,
                                                                     ServerConfiguration serverConfiguration,
                                                                     XlrConfig xlrConfig, PermissionEnforcer permissionEnforcer) {
        JettyServletWebServerFactory factory = new ReleaseJettyServletWebServerFactory(serverConfiguration, xlrConfig, permissionEnforcer);
        factory.getServerCustomizers().addAll(jettyServerCustomizers.orderedStream().collect(Collectors.toList()));
        return factory;
    }

    @Bean
    public JettyServerListener jettyServerListener(final ServerConfiguration serverConfiguration) {
        return new JettyServerListener(serverConfiguration);
    }

    @Bean
    public ShutdownEventListener shutdownEventListener(final ApplicationContext applicationContext) {
        return new ShutdownEventListener(applicationContext);
    }
}
