package com.xebialabs.xlrelease.upgrade;

import java.util.List;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import com.xebialabs.deployit.server.api.upgrade.Version;

/**
 * This class must be implemented when an upgrade must be performed
 * ONLY on template import
 *
 * @see com.xebialabs.xlrelease.upgrade.JsonUpgrade
 */
public interface ImportUpgrade {
    /**
     * Modifies a release at JSON level
     *
     * @param release the release JSON object
     * @return {@link UpgradeResult}
     */
    UpgradeResult performUpgrade(JSONObject release) throws JSONException;

    Version getUpgradeVersion();
}
