package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.security.RoleService
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.security.XLReleasePermissions
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging

import scala.util.{Failure, Success, Try}

class XLRelease233AuthenticatedUsersRoleUpgrade(roleService: RoleService) extends BaseInitializingUpgrade with Logging {
  override def doUpgrade(): Boolean = {
    logger.info(s"Creating global role '${XLReleasePermissions.GLOBAL_AUTHENTICATED_USERS_ROLE}'")
    Try {
      if (!roleService.roleExists(XLReleasePermissions.GLOBAL_AUTHENTICATED_USERS_ROLE)) {
        val roleId = roleService.create(XLReleasePermissions.GLOBAL_AUTHENTICATED_USERS_ROLE)
        val role = roleService.getRoleForRoleId(roleId)
        role.withPrincipals(XLReleasePermissions.AUTHENTICATED_USER)
        roleService.createOrUpdateRole(role)
      } else {
        logger.info(s"Global role '${XLReleasePermissions.GLOBAL_AUTHENTICATED_USERS_ROLE}' already exists")
      }
    } match {
      case Failure(exception) =>
        logger.error(s"Unable to create global role '${XLReleasePermissions.GLOBAL_AUTHENTICATED_USERS_ROLE}'", exception)
      case Success(_) =>
        logger.debug(s"Created global role '${XLReleasePermissions.GLOBAL_AUTHENTICATED_USERS_ROLE}'")
    }
    true
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "23.3.0#2")
}
