package com.xebialabs.xlrelease.views;

import java.util.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.api.internal.EffectiveSecurity;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;
import com.xebialabs.xlrelease.serialization.json.jackson.PasswordDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.PasswordSerializer;

public class ReleaseFullView extends PlanItemFullView implements BaseView {

    private ReleaseKind kind;

    private ReleaseStatus status;

    private String currentPhase;

    private TaskFullView currentTask;

    private List<TaskFullView> currentSimpleTasks;

    private List<PhaseFullView> phases;

    private UserView owner;

    private Map<String, String> variables;

    private List<String> tags;

    private List<AttachmentView> attachments;

    private boolean autoStart;

    /**
     * A release is flagged if the release itself is flagged OR if one of its tasks is flagged
     * - releaseFlag contains flag status for the actual release
     * - flag contains flag status for the release OR its subtasks
     */
    private Flag releaseFlag;
    private Flag flag;

    private String calendarLinkToken;

    private boolean calendarPublished;

    private boolean tutorial;

    private boolean abortOnFailure;

    private boolean archiveRelease;

    private boolean allowPasswordsInAllFields;

    private boolean disableNotifications;

    private boolean allowConcurrentReleasesFromTrigger;

    private EffectiveSecurity security;

    private UserView scriptUsername;

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String startedFromTaskId;

    private String startedFromTaskReleaseTitle;

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String originTemplateId;

    private String originTemplateTitle;

    @JsonSerialize(using = PasswordSerializer.class)
    @JsonDeserialize(using = PasswordDeserializer.class)
    private String scriptUserPassword;

    private boolean archived;

    private String author;

    private TemplateLogoView logo;

    private Map<String, ReleaseExtensionView> extensions;

    private Map<String, Object> syntheticProperties;

    private String abortComment;

    private Integer $scmTraceabilityDataId;

    private Map<String, String> variableMapping = new HashMap<>();

    private Set<String> categories = new HashSet<>();

    public ReleaseFullView() {
    }

    public void setStatus(final ReleaseStatus status) {
        this.status = status;
    }

    public ReleaseStatus getStatus() {
        return status;
    }

    public void setCurrentPhase(final String currentPhase) {
        this.currentPhase = currentPhase;
    }

    public String getCurrentPhase() {
        return currentPhase;
    }

    public void setCurrentTask(final TaskFullView currentTask) {
        this.currentTask = currentTask;
    }

    public TaskFullView getCurrentTask() {
        return currentTask;
    }

    public void setCurrentSimpleTasks(final List<TaskFullView> currentSimpleTasks) {
        this.currentSimpleTasks = currentSimpleTasks;
    }

    public List<TaskFullView> getCurrentSimpleTasks() {
        return currentSimpleTasks;
    }

    public void setPhases(final List<PhaseFullView> phases) {
        this.phases = phases;
    }

    public List<PhaseFullView> getPhases() {
        return phases;
    }

    public void setOwner(final UserView owner) {
        this.owner = owner;
    }

    public UserView getOwner() {
        return owner;
    }

    public Map<String, String> getVariables() {
        return variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public void setTags(final List<String> tags) {
        this.tags = tags;
    }

    public List<String> getTags() {
        return tags;
    }

    public void setAttachments(final List<AttachmentView> attachments) {
        this.attachments = attachments;
    }

    public List<AttachmentView> getAttachments() {
        return attachments;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean getAutoStart() {
        return autoStart;
    }

    public void setReleaseFlag(final Flag releaseFlag) {
        this.releaseFlag = releaseFlag;
    }

    public Flag getReleaseFlag() {
        return releaseFlag;
    }

    public void setFlag(final Flag flag) {
        this.flag = flag;
    }

    public Flag getFlag() {
        return flag;
    }

    public void setCalendarLinkToken(final String calendarLinkToken) {
        this.calendarLinkToken = calendarLinkToken;
    }

    public String getCalendarLinkToken() {
        return calendarLinkToken;
    }

    public void setCalendarPublished(final boolean calendarPublished) {
        this.calendarPublished = calendarPublished;
    }

    public boolean isCalendarPublished() {
        return calendarPublished;
    }

    public void setSecurity(final EffectiveSecurity security) {
        this.security = security;
    }

    public EffectiveSecurity getSecurity() {
        return security;
    }

    public void setTutorial(final boolean tutorial) {
        this.tutorial = tutorial;
    }

    public boolean isTutorial() {
        return tutorial;
    }

    public void setAbortOnFailure(final boolean abortOnFailure) {
        this.abortOnFailure = abortOnFailure;
    }

    public boolean isAbortOnFailure() {
        return abortOnFailure;
    }

    public void setArchiveRelease(final boolean archiveRelease) {
        this.archiveRelease = archiveRelease;
    }

    public boolean isArchiveRelease() {
        return archiveRelease;
    }

    public boolean isAllowPasswordsInAllFields() {
        return allowPasswordsInAllFields;
    }

    public void setAllowPasswordsInAllFields(final boolean allowPasswordsInAllFields) {
        this.allowPasswordsInAllFields = allowPasswordsInAllFields;
    }

    public boolean isDisableNotifications() {
        return disableNotifications;
    }

    public void setDisableNotifications(final boolean disableNotifications) {
        this.disableNotifications = disableNotifications;
    }

    public void setAllowConcurrentReleasesFromTrigger(final boolean allowConcurrentReleasesFromTrigger) {
        this.allowConcurrentReleasesFromTrigger = allowConcurrentReleasesFromTrigger;
    }

    public boolean isAllowConcurrentReleasesFromTrigger() {
        return allowConcurrentReleasesFromTrigger;
    }

    public void setScriptUsername(final UserView scriptUsername) {
        this.scriptUsername = scriptUsername;
    }

    public UserView getScriptUsername() {
        return scriptUsername;
    }

    public void setScriptUserPassword(final String scriptUserPassword) {
        this.scriptUserPassword = scriptUserPassword;
    }

    public String getScriptUserPassword() {
        return scriptUserPassword;
    }

    public void setStartedFromTaskId(final String startedFromTaskId) {
        this.startedFromTaskId = startedFromTaskId;
    }

    public String getStartedFromTaskId() {
        return startedFromTaskId;
    }

    public void setStartedFromTaskReleaseTitle(final String startedFromTaskReleaseTitle) {
        this.startedFromTaskReleaseTitle = startedFromTaskReleaseTitle;
    }

    public String getStartedFromTaskReleaseTitle() {
        return startedFromTaskReleaseTitle;
    }

    public void setOriginTemplateTitle(final String originTemplateTitle) {
        this.originTemplateTitle = originTemplateTitle;
    }

    public String getOriginTemplateTitle() {
        return originTemplateTitle;
    }

    public void setOriginTemplateId(final String originTemplateId) {
        this.originTemplateId = originTemplateId;
    }

    public String getOriginTemplateId() {
        return originTemplateId;
    }

    public void setArchived(final boolean archived) {
        this.archived = archived;
    }

    public boolean isArchived() {
        return archived;
    }

    public Map<String, ReleaseExtensionView> getExtensions() {
        return extensions;
    }

    @Override
    public void setExtensions(final Map<String, ReleaseExtensionView> extensions) {
        this.extensions = extensions;
    }

    public Map<String, Object> getSyntheticProperties() {
        return syntheticProperties;
    }

    @Override
    public void setSyntheticProperties(final Map<String, Object> syntheticProperties) {
        this.syntheticProperties = syntheticProperties;
    }

    public String getAbortComment() {
        return abortComment;
    }

    public void setAbortComment(String abortComment) {
        this.abortComment = abortComment;
    }

    public Integer get$scmTraceabilityDataId() {
        return $scmTraceabilityDataId;
    }

    public void set$scmTraceabilityDataId(final Integer $scmTraceabilityDataId) {
        this.$scmTraceabilityDataId = $scmTraceabilityDataId;
    }

    public Map<String, String> getVariableMapping() {
        return variableMapping;
    }

    public void setVariableMapping(Map<String, String> variableMapping) {
        this.variableMapping = variableMapping;
    }

    public ReleaseKind getKind() {
        return kind;
    }

    public void setKind(final ReleaseKind kind) {
        this.kind = kind;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(final String author) {
        this.author = author;
    }

    public TemplateLogoView getLogo() {
        return logo;
    }

    public void setLogo(final TemplateLogoView logo) {
        this.logo = logo;
    }

    public Set<String> getCategories() {
        return categories;
    }

    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }
}
