/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.logs;

import akka.actor.ActorRef;
import com.xebialabs.xlrelease.domain.events.TaskJobExecutedEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.scheduler.events.JobFinishedEvent;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatchActor;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatcherSupervisor;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLog;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository;
import com.xebialabs.xlrelease.scheduler.logs.TaskLogCreated;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import com.xebialabs.xlrelease.storage.domain.StorageEntry;
import com.xebialabs.xlrelease.storage.service.StorageService;
import com.xebialabs.xlrelease.support.akka.spring.SpringExtension;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.TaskExecutionLogView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!q\u0005A!A!\u0002\u0013y\u0005\"B*\u0001\t\u0003!\u0006\u0002C.\u0001\u0011\u000b\u0007I\u0011\u0002/\t\u000b\u0011\u0004A\u0011A3\t\u000ba\u0004A\u0011A=\t\u000bm\u0004A\u0011\u0001?\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!a0\u0001\t\u0003\t\tmB\u0004\u0002rZA\t!a=\u0007\rU1\u0002\u0012AA{\u0011\u0019\u0019&\u0003\"\u0001\u0002x\"9\u0011\u0011 \n\u0005\u0002\u0005m(a\u0006+bg.,\u00050Z2vi&|g\u000eT8h'\u0016\u0014h/[2f\u0015\t9\u0002$\u0001\u0003m_\u001e\u001c(BA\r\u001b\u0003%\u00198\r[3ek2,'O\u0003\u0002\u001c9\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003;y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003}\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0012)!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\u0006g24GG\u001b\u0006\u0002[\u0005AqM]5{u2,G-\u0003\u00020U\t9Aj\\4hS:<\u0017aD:qe&tw-\u0012=uK:\u001c\u0018n\u001c8\u0011\u0005IJT\"A\u001a\u000b\u0005Q*\u0014AB:qe&twM\u0003\u00027o\u0005!\u0011m[6b\u0015\tA$$A\u0004tkB\u0004xN\u001d;\n\u0005i\u001a$aD*qe&tw-\u0012=uK:\u001c\u0018n\u001c8\u0002!\t\u0014x.\u00193dCN$8+\u001a:wS\u000e,\u0007CA\u001fA\u001b\u0005q$BA \u001b\u0003\u001d\u0019XM\u001d<jG\u0016L!!\u0011 \u0003!\t\u0013x.\u00193dCN$8+\u001a:wS\u000e,\u0017AD:u_J\fw-Z*feZL7-\u001a\t\u0003\t\"k\u0011!\u0012\u0006\u0003\u007f\u0019S!a\u0012\u000e\u0002\u000fM$xN]1hK&\u0011\u0011*\u0012\u0002\u000f'R|'/Y4f'\u0016\u0014h/[2f\u0003-!\u0018m]6TKJ4\u0018nY3\u0011\u0005ub\u0015BA'?\u0005-!\u0016m]6TKJ4\u0018nY3\u0002/Q\f7o[#yK\u000e,H/[8o%\u0016\u0004xn]5u_JL\bC\u0001)R\u001b\u00051\u0012B\u0001*\u0017\u0005]!\u0016m]6Fq\u0016\u001cW\u000f^5p]J+\u0007o\\:ji>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0007+Z;\u0006,\u0017.\u0011\u0005A\u0003\u0001\"\u0002\u0019\u0007\u0001\u0004\t\u0004\"B\u001e\u0007\u0001\u0004a\u0004\"\u0002\"\u0007\u0001\u0004\u0019\u0005\"\u0002&\u0007\u0001\u0004Y\u0005\"\u0002(\u0007\u0001\u0004y\u0015aG3yK\u000e,H/[8o\u0019><w+\u0019;dQ\u0016\u0014\u0018i\u0019;peJ+g-F\u0001^!\tq&-D\u0001`\u0015\t\u0001\u0017-A\u0003bGR|'OC\u00017\u0013\t\u0019wL\u0001\u0005BGR|'OU3g\u0003\u00159\u0018\r^2i)\r1\u0017N\u001e\t\u0003G\u001dL!\u0001\u001b\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006U\"\u0001\ra[\u0001\u0007i\u0006\u001c8.\u00133\u0011\u00051\u001chBA7r!\tqG%D\u0001p\u0015\t\u0001\b%\u0001\u0004=e>|GOP\u0005\u0003e\u0012\na\u0001\u0015:fI\u00164\u0017B\u0001;v\u0005\u0019\u0019FO]5oO*\u0011!\u000f\n\u0005\u0006o\"\u0001\ra[\u0001\fKb,7-\u001e;j_:LE-A\u0005ti>\u0004x+\u0019;dQR\u0011aM\u001f\u0005\u0006o&\u0001\ra[\u0001\u0006M\u0016$8\r\u001b\u000b\tMvtx0a\u0005\u0002B!)!N\u0003a\u0001W\")qO\u0003a\u0001W\"9\u0011\u0011\u0001\u0006A\u0002\u0005\r\u0011\u0001D8viB,Ho\u0015;sK\u0006l\u0007\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0003S>T!!!\u0004\u0002\t)\fg/Y\u0005\u0005\u0003#\t9A\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002\u0016)\u0001\r!a\u0006\u0002\u000f1\f7\u000f\u001e&pEB!\u0011\u0011DA\u001e\u001d\u0011\tY\"!\u000e\u000f\t\u0005u\u0011q\u0006\b\u0005\u0003?\tYC\u0004\u0003\u0002\"\u0005%b\u0002BA\u0012\u0003Oq1A\\A\u0013\u0013\u0005y\u0012BA\u000f\u001f\u0013\tYB$C\u0002\u0002.i\taA];o]\u0016\u0014\u0018\u0002BA\u0019\u0003g\ta\u0001Z8nC&t'bAA\u00175%!\u0011qGA\u001d\u0003\u001d\u0001\u0018mY6bO\u0016TA!!\r\u00024%!\u0011QHA \u0005\u0015QuNY%e\u0015\u0011\t9$!\u000f\t\u000f\u0005\r#\u00021\u0001\u0002F\u0005IA.Y:u\u0007\",hn\u001b\t\u0004G\u0005\u001d\u0013bAA%I\t!Aj\u001c8h\u0003I1W\r^2i\u00032dW\t_3dkRLwN\\:\u0015\t\u0005=\u0013q\r\t\u0007\u0003#\n9&a\u0017\u000e\u0005\u0005M#\u0002BA+\u0003\u0017\tA!\u001e;jY&!\u0011\u0011LA*\u0005\u0011a\u0015n\u001d;\u0011\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u0019\u001b\u0003\u00151\u0018.Z<t\u0013\u0011\t)'a\u0018\u0003)Q\u000b7o[#yK\u000e,H/[8o\u0019><g+[3x\u0011\u0015Q7\u00021\u0001l\u0003\rawn\u001a\u000b\u0004M\u00065\u0004bBA8\u0019\u0001\u0007\u0011\u0011O\u0001\tY><WI\u001c;ssB!\u00111OA<\u001b\t\t)HC\u0002\u00022\u0019KA!!\u001f\u0002v\tAAj\\4F]R\u0014\u00180A\u000bhKR$\u0016m]6Fq\u0016\u001cW\u000f^5p]\u0016sGO]=\u0015\r\u0005}\u00141RAG!\u0015\u0019\u0013\u0011QAC\u0013\r\t\u0019\t\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007A\u000b9)C\u0002\u0002\nZ\u0011!\u0003V1tW\u0016CXmY;uS>tWI\u001c;ss\")!.\u0004a\u0001W\")q/\u0004a\u0001W\u0006iqN\u001c&pE\u001aKg.[:iK\u0012$2AZAJ\u0011\u001d\t)J\u0004a\u0001\u0003/\u000bQ!\u001a<f]R\u0004B!!'\u0002 6\u0011\u00111\u0014\u0006\u0004\u0003;C\u0012AB3wK:$8/\u0003\u0003\u0002\"\u0006m%\u0001\u0005&pE\u001aKg.[:iK\u0012,e/\u001a8uQ\rq\u0011Q\u0015\t\u0005\u0003O\u000bY+\u0004\u0002\u0002**\u0019\u0011Q\u0014\u000e\n\t\u00055\u0016\u0011\u0016\u0002\n'V\u00147o\u0019:jE\u0016\f\u0001c\u001c8UCN\\Gj\\4De\u0016\fG/\u001a3\u0015\u0007\u0019\f\u0019\fC\u0004\u00026>\u0001\r!a.\u0002\u0019Q\f7o\u001b'pO\u00163XM\u001c;\u0011\u0007A\u000bI,C\u0002\u0002<Z\u0011a\u0002V1tW2{wm\u0011:fCR,G\rK\u0002\u0010\u0003K\u000b1c\u001c8UCN\\W\t_3dkRLwN\u001c#p]\u0016$2AZAb\u0011\u001d\t)\n\u0005a\u0001\u0003\u000b\u0004B!a2\u0002N6\u0011\u0011\u0011\u001a\u0006\u0005\u0003;\u000bYMC\u0002\u00022iIA!a4\u0002J\n!B+Y:l\u0015>\u0014W\t_3dkR,G-\u0012<f]RD3\u0001EASQ\r\u0001\u0011Q\u001b\t\u0005\u0003O\u000b9.\u0003\u0003\u0002Z\u0006%&!D#wK:$H*[:uK:,'\u000fK\u0002\u0001\u0003;\u0004B!a8\u0002n6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\f)/\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TA!a:\u0002j\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002l\u0006\u0019qN]4\n\t\u0005=\u0018\u0011\u001d\u0002\b'\u0016\u0014h/[2f\u0003]!\u0016m]6Fq\u0016\u001cW\u000f^5p]2{wmU3sm&\u001cW\r\u0005\u0002Q%M\u0011!C\t\u000b\u0003\u0003g\fA\u0001[1tQR\u00191.!@\t\u000b)$\u0002\u0019A6")
public class TaskExecutionLogService
implements Logging {
    private ActorRef executionLogWatcherActorRef;
    private final SpringExtension springExtension;
    private final BroadcastService broadcastService;
    private final StorageService storageService;
    private final TaskService taskService;
    private final TaskExecutionRepository taskExecutionRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static String hash(String taskId) {
        return TaskExecutionLogService$.MODULE$.hash(taskId);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private ActorRef executionLogWatcherActorRef$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$0) {
                this.executionLogWatcherActorRef = this.springExtension.actorOf(ExecutionLogWatcherSupervisor.class, "execution-log-watchers", this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = true;
            }
        }
        return this.executionLogWatcherActorRef;
    }

    private ActorRef executionLogWatcherActorRef() {
        if (!this.bitmap$0) {
            return this.executionLogWatcherActorRef$lzycompute();
        }
        return this.executionLogWatcherActorRef;
    }

    public void watch(String taskId, String executionId) {
        ExecutionLogWatchActor.StartWatch x$1 = new ExecutionLogWatchActor.StartWatch(taskId, executionId, User.AUTHENTICATED_USER.getName());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public void stopWatch(String executionId) {
        ExecutionLogWatchActor.StopWatching x$1 = new ExecutionLogWatchActor.StopWatching(executionId, (Option<String>)new Some((Object)User.AUTHENTICATED_USER.getName()));
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public void fetch(String taskId, String executionId, OutputStream outputStream, long lastJob, long lastChunk) {
        new TaskExecutionLog(taskId, executionId).fetch(this.storageService, outputStream, lastJob, lastChunk);
    }

    public List<TaskExecutionLogView> fetchAllExecutions(String taskId) {
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.taskExecutionRepository.find(new TaskExecutionRepository.ByTaskId(taskId), Pageable.unpaged()).getContent()).asScala().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long l;
                TaskExecutionEntry row = (TaskExecutionEntry)tuple2._1();
                int index = tuple2._2$mcI$sp();
                TaskExecutionLogView view = new TaskExecutionLogView();
                view.setId(row.executionId());
                view.setExecutionNo(Predef$.MODULE$.int2Integer(index + 1));
                view.setLastJob(Predef$.MODULE$.long2Long((long)row.lastJob()));
                view.setLastChunk(Predef$.MODULE$.int2Integer(row.lastChunk()));
                Option option = Option$.MODULE$.apply((Object)row.lastModifiedDate());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Instant date2 = (Instant)some.value();
                    l = date2.toEpochMilli();
                } else if (None$.MODULE$.equals(option)) {
                    l = Instant.now().toEpochMilli();
                } else {
                    throw new MatchError((Object)option);
                }
                long modifiedDate = l;
                view.setModifiedDate(Predef$.MODULE$.long2Long(modifiedDate));
                Option$.MODULE$.apply((Object)row.endDate()).foreach((Function1 & Serializable)date -> {
                    view.setEndDate(Predef$.MODULE$.long2Long(date.toEpochMilli()));
                    return BoxedUnit.UNIT;
                });
                return view;
            }
            throw new MatchError((Object)tuple2);
        })).asJava();
    }

    public void log(LogEntry logEntry) {
        String x$1 = "xlr-local";
        String x$2 = logEntry.copy$default$1();
        String x$3 = logEntry.copy$default$2();
        long x$4 = logEntry.copy$default$3();
        long x$5 = logEntry.copy$default$4();
        String x$6 = logEntry.copy$default$5();
        byte[] x$7 = logEntry.copy$default$6();
        LogEntry workerLogEntry = logEntry.copy(x$2, x$3, x$4, x$5, x$6, x$7, "xlr-local");
        URI storedEntryUri = this.storageService.store((StorageEntry)workerLogEntry);
        TaskStatus taskStatus = this.taskService.getStatus(logEntry.taskId());
        this.logger().info((Function0 & Serializable)() -> "Adding log entry with task status: " + taskStatus);
        Option<TaskExecutionEntry> option = taskStatus.isOneOf(new TaskStatus[]{TaskStatus.COMPLETED, TaskStatus.SKIPPED, TaskStatus.ABORTED, TaskStatus.FAILED, TaskStatus.FAILING, TaskStatus.ABORT_SCRIPT_IN_PROGRESS, TaskStatus.FAILURE_HANDLER_IN_PROGRESS}) ? this.taskExecutionRepository.update(new TaskExecutionRepository.UpdateWithLogEntry(workerLogEntry, (Option<Instant>)new Some((Object)Instant.now()))) : this.taskExecutionRepository.update(new TaskExecutionRepository.UpdateWithLogEntry(workerLogEntry, (Option<Instant>)None$.MODULE$));
        this.broadcastService.broadcast(new TaskLogCreated(logEntry.taskId(), logEntry.executionId(), storedEntryUri), true);
    }

    public Option<TaskExecutionEntry> getTaskExecutionEntry(String taskId, String executionId) {
        return this.taskExecutionRepository.read(taskId, executionId);
    }

    @Subscribe
    public void onJobFinished(JobFinishedEvent event) {
        long jobId = event.jobId();
        String executionId = event.executionId();
        this.logger().debug((Function0 & Serializable)() -> "finishing job " + jobId);
        ExecutionLogWatchActor.Check x$1 = new ExecutionLogWatchActor.Check(executionId);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskLogCreated(TaskLogCreated taskLogEvent) {
        this.logger().debug((Function0 & Serializable)() -> "processing log event " + taskLogEvent);
        ExecutionLogWatchActor.NewEntry x$1 = new ExecutionLogWatchActor.NewEntry(taskLogEvent.executionId(), taskLogEvent.uri());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskExecutionDone(TaskJobExecutedEvent event) {
        TaskExecutionRepository.FinishExecution finishExecution = new TaskExecutionRepository.FinishExecution(event.taskId(), event.executionId(), Instant.now());
        this.taskExecutionRepository.update(finishExecution);
    }

    public TaskExecutionLogService(SpringExtension springExtension, BroadcastService broadcastService, StorageService storageService, TaskService taskService, TaskExecutionRepository taskExecutionRepository) {
        this.springExtension = springExtension;
        this.broadcastService = broadcastService;
        this.storageService = storageService;
        this.taskService = taskService;
        this.taskExecutionRepository = taskExecutionRepository;
        Logging.$init$((Logging)this);
    }
}

