/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.xlrelease.api.v1.filter.CategoryFilters;
import com.xebialabs.xlrelease.domain.Category;
import com.xebialabs.xlrelease.domain.events.CategoryCreatedEvent;
import com.xebialabs.xlrelease.domain.events.CategoryDeletedEvent;
import com.xebialabs.xlrelease.domain.events.CategoryUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.CategoryRepository;
import com.xebialabs.xlrelease.view.CategoryView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001\u0002\u0006\f\u0001QA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!)\u0011\u0007\u0001C\u0001e!)q\u0007\u0001C\u0001q!)q\r\u0001C\u0001Q\")\u0011\u000f\u0001C\u0001e\")Q\u000f\u0001C\u0001m\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0001bBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0002\u0010\u0007\u0006$XmZ8ssN+'O^5dK*\u0011A\"D\u0001\bg\u0016\u0014h/[2f\u0015\tqq\"A\u0005yYJ,G.Z1tK*\u0011\u0001#E\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AE\u0001\u0004G>l7\u0001A\n\u0004\u0001UY\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001dC5\tQD\u0003\u0002\u001f?\u0005)1\u000f\u001c45U*\t\u0001%\u0001\u0005he&T(\u0010\\3e\u0013\t\u0011SDA\u0004M_\u001e<\u0017N\\4\u0002%\r\fG/Z4pef\u0014V\r]8tSR|'/\u001f\t\u0003K!j\u0011A\n\u0006\u0003O5\t!B]3q_NLGo\u001c:z\u0013\tIcE\u0001\nDCR,wm\u001c:z%\u0016\u0004xn]5u_JL\u0018\u0001C3wK:$()^:\u0011\u00051zS\"A\u0017\u000b\u00059j\u0011AB3wK:$8/\u0003\u00021[\tAQI^3oi\n+8/\u0001\u0004=S:LGO\u0010\u000b\u0004gU2\u0004C\u0001\u001b\u0001\u001b\u0005Y\u0001\"B\u0012\u0004\u0001\u0004!\u0003\"\u0002\u0016\u0004\u0001\u0004Y\u0013A\u00024j]\u0012\u0014\u0015\u0010F\u0002:\u0017^\u00032AO\"F\u001b\u0005Y$B\u0001\u001f>\u0003\u0019!w.\\1j]*\u0011ahP\u0001\u0005I\u0006$\u0018M\u0003\u0002A\u0003\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001C\u0003\ry'oZ\u0005\u0003\tn\u0012A\u0001U1hKB\u0011a)S\u0007\u0002\u000f*\u0011\u0001*D\u0001\u0005m&,w/\u0003\u0002K\u000f\na1)\u0019;fO>\u0014\u0018PV5fo\")A\n\u0002a\u0001\u001b\u0006y1-\u0019;fO>\u0014\u0018PR5mi\u0016\u00148\u000f\u0005\u0002O+6\tqJ\u0003\u0002Q#\u00061a-\u001b7uKJT!AU*\u0002\u0005Y\f$B\u0001+\u000e\u0003\r\t\u0007/[\u0005\u0003->\u0013qbQ1uK\u001e|'/\u001f$jYR,'o\u001d\u0005\u00061\u0012\u0001\r!W\u0001\ta\u0006<W-\u00192mKB\u0011!HW\u0005\u00037n\u0012\u0001\u0002U1hK\u0006\u0014G.\u001a\u0015\u0003\tu\u0003\"AX3\u000e\u0003}S!\u0001Y1\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002cG\u00069Q.\u001a;sS\u000e\u001c(B\u00013\u0012\u0003!\u0019w\u000eZ1iC2,\u0017B\u00014`\u0005\u0015!\u0016.\\3e\u0003\u0019\u0019'/Z1uKR\u0011\u0011N\u001c\t\u0003U2l\u0011a\u001b\u0006\u0003y5I!!\\6\u0003\u0011\r\u000bG/Z4pefDQa\\\u0003A\u0002%\f\u0001bY1uK\u001e|'/\u001f\u0015\u0003\u000bu\u000ba!\u001e9eCR,GCA5t\u0011\u0015yg\u00011\u0001jQ\t1Q,\u0001\u0004eK2,G/\u001a\u000b\u0003oj\u0004\"A\u0006=\n\u0005e<\"\u0001B+oSRDQa_\u0004A\u0002q\f!!\u001b3\u0011\u0005Yi\u0018B\u0001@\u0018\u0005\rIe\u000e\u001e\u0015\u0003\u000fu\u000baC^1mS\u0012\fG/Z!oI\u001aK\u0007pQ1uK\u001e|'/\u001f\u000b\u0004o\u0006\u0015\u0001\"B8\t\u0001\u0004I\u0017AE2iK\u000e\\gi\u001c:EkBd\u0017nY1uKN$2a^A\u0006\u0011\u0015y\u0017\u00021\u0001j\u0001")
public class CategoryService
implements Logging {
    private final CategoryRepository categoryRepository;
    private final EventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CategoryService categoryService = this;
        synchronized (categoryService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Page<CategoryView> findBy(CategoryFilters categoryFilters, Pageable pageable) {
        return this.categoryRepository.findBy(categoryFilters, pageable);
    }

    @Timed
    public Category create(Category category) {
        category.setCiUid(null);
        this.validateAndFixCategory(category);
        this.checkForDuplicates(category);
        Category createdCategory = this.categoryRepository.create(category);
        this.eventBus.publish((XLReleaseEvent)new CategoryCreatedEvent(createdCategory));
        return createdCategory;
    }

    @Timed
    public Category update(Category category) {
        if (category.getCiUid() == null) {
            throw new IllegalArgumentException("The category ciUid must not be null or empty");
        }
        Option<Category> option = this.categoryRepository.findByCiUid(Predef$.MODULE$.Integer2int(category.getCiUid()));
        if (option instanceof Some) {
            Some some = (Some)option;
            Category originalCategory = (Category)some.value();
            this.validateAndFixCategory(category);
            String string = originalCategory.getTitle().toLowerCase();
            String string2 = category.getTitle().toLowerCase();
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkForDuplicates(category);
            }
            Category updatedCategory = this.categoryRepository.update(category);
            this.eventBus.publish((XLReleaseEvent)new CategoryUpdatedEvent(originalCategory, updatedCategory));
            return updatedCategory;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("The category '" + category.getCiUid() + "' does not exist");
        }
        throw new MatchError(option);
    }

    @Timed
    public void delete(int id) {
        Option<Category> option = this.categoryRepository.findByCiUid(id);
        if (option instanceof Some) {
            Some some = (Some)option;
            Category category = (Category)some.value();
            this.categoryRepository.delete(id);
            this.eventBus.publish((XLReleaseEvent)new CategoryDeletedEvent(category));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private void validateAndFixCategory(Category category) {
        String categoryStr = category.getTitle();
        if (!StringUtils.hasText((String)categoryStr)) {
            throw new IllegalArgumentException("The category title must not be null or empty");
        }
        categoryStr = Category.sanitizeTitle((String)categoryStr);
        category.setTitle(categoryStr);
        if (category.getActive() == null) {
            category.setActive(true);
            return;
        }
    }

    private void checkForDuplicates(Category category) {
        Option<Category> found = this.categoryRepository.findByTitle(category.getTitle());
        Option<Category> option = found;
        if (option instanceof Some) {
            Some some = (Some)option;
            Category existingCategory = (Category)some.value();
            Integer n = category.getCiUid();
            Integer n2 = existingCategory.getCiUid();
            if (n == null ? n2 != null : !((Object)n).equals(n2)) {
                throw new ItemAlreadyExistsException("The category '%s' already exists", new Object[]{category.getTitle()});
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public CategoryService(CategoryRepository categoryRepository, EventBus eventBus) {
        this.categoryRepository = categoryRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

