package com.xebialabs.deployit.plumbing.authentication;

import java.io.Serializable;
import org.springframework.security.core.AuthenticatedPrincipal;

import static com.xebialabs.deployit.checks.Checks.checkNotNull;

/**
 * A representation of a user {@code Principal} that is registered with an Internal Release
 * Provider.
 */
public class InternalUser implements AuthenticatedPrincipal, Serializable {
    private final String username;

    public InternalUser(final String username) {
        checkNotNull(username, "username should not be null");
        this.username = username;
    }

    @Override
    public String toString() {
        return this.username;
    }

    @Override
    public String getName() {
        return this.username;
    }
}
