package com.xebialabs.deployit.plumbing.authentication;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

/**
 * Used to avoid default redirect on login that is not supported by our acceptance test launcher.
 * https://github.com/karma-runner/karma/issues/127
 */
public class WithoutRedirectLoginSuccessHandler implements AuthenticationSuccessHandler {
    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (authentication != null) {
            response.setStatus(HttpServletResponse.SC_OK);
        }
    }
}
