package com.xebialabs.xlrelease

import com.xebialabs.deployit.ServerConfigFile
import com.xebialabs.plugin.manager.cli.PluginManagerCliLaunchOptions.parseCommandLine
import com.xebialabs.plugin.manager.cli.{PluginManagerCli, PluginManagerCliLaunchOptions}
import com.xebialabs.plugin.manager.metadata.Version
import com.xebialabs.plugin.manager.metadata.XLProduct.XLRelease
import com.xebialabs.plugin.manager.repository.sql.SqlPluginRepository
import com.xebialabs.xlrelease.XLReleaseBootstrapper.releaseServer
import com.xebialabs.xlrelease.config.XlrConfig
import com.zaxxer.hikari.{HikariConfig, HikariDataSource}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.util.ResourceUtils

object PluginManagerCliBootstrapper {

  def main(args: Array[String]): Unit = {
    val cliLaunchOptions = parseCommandLine(args)
    if (cliLaunchOptions == null) {
      System.exit(0)
    }

    val serverLaunchOptions = new XLReleaseServerLaunchOptions

    val serverConfFile = ResourceUtils.getFile(XlrConfig.bootConfig.confFile_location)
    val confFile = new ServerConfigFile(serverConfFile)

    releaseServer = new ReleaseServer(serverLaunchOptions, confFile)
    releaseServer.prepareConfigs()

    runPluginManagerCli(cliLaunchOptions)

    System.exit(0)
  }

  def runPluginManagerCli(options: PluginManagerCliLaunchOptions): Unit = {
    val ds = dataSource()
    val repository = sqlPluginRepository(ds)
    val cli = pluginManagerCli(repository)
    val output = cli.run(options)
    println(output)
    ds.close()
  }

  def dataSource(): HikariDataSource = {
    val xlrConfig = XlrConfig.getInstance
    val cfg = new HikariConfig()
    cfg.setDriverClassName(xlrConfig.xlrRepositoryDriver)
    cfg.setJdbcUrl(xlrConfig.xlrRepositoryJdbcUrl)
    cfg.setUsername(xlrConfig.xlrRepositoryUsername)
    cfg.setPassword(xlrConfig.xlrRepositoryPassword)
    new HikariDataSource(cfg)
  }

  def sqlPluginRepository(dataSource: HikariDataSource): SqlPluginRepository = new SqlPluginRepository(new JdbcTemplate(dataSource))

  def pluginManagerCli(sqlPluginRepository: SqlPluginRepository): PluginManagerCli =
    new PluginManagerCli(sqlPluginRepository, XLRelease, Version.zero.id)

}

