package com.xebialabs.xlrelease.actors.kryoserializers

import com.esotericsoftware.kryo.io.{Input, Output}
import com.esotericsoftware.kryo.{Kryo, Serializer}
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException
import grizzled.slf4j.Logging

object LogFriendlyNotFoundExceptionSerializer extends Serializer[LogFriendlyNotFoundException] with Logging {
  override def write(kryo: Kryo, output: Output, item: LogFriendlyNotFoundException): Unit = {
    logger.debug(s"Serializing LogFriendlyNotFoundException", item)
    kryo.writeClassAndObject(output, item.getErrors)
    kryo.writeClassAndObject(output, item.getCause)
    kryo.writeClassAndObject(output, item.getStackTrace)
  }

  override def read(kryo: Kryo, input: Input, objectType: Class[_ <: LogFriendlyNotFoundException]): LogFriendlyNotFoundException = {
    val errors = kryo.readClassAndObject(input).asInstanceOf[java.util.List[String]]
    val cause = kryo.readClassAndObject(input).asInstanceOf[Throwable]
    val stacktrace = kryo.readClassAndObject(input).asInstanceOf[Array[StackTraceElement]]
    logger.debug(s"Deserialized LogFriendlyNotFoundException")
    val ex = if (cause != null) {
      new LogFriendlyNotFoundException(cause, errors.get(0))
    } else {
      new LogFriendlyNotFoundException(errors.get(0))
    }
    ex.setStackTrace(stacktrace)
    ex
  }
}
