package com.xebialabs.xlrelease.domain.utils

import com.xebialabs.deployit.plugin.api.udm.CiAttributes
import com.xebialabs.xlrelease.domain.{Release, Task}
import com.xebialabs.xlrelease.repository.CiCloneHelper.cloneCi

import scala.jdk.CollectionConverters._

object ReleaseCloneHelper {

  def clone[T <: Task](task: T): T = {
    val release = task.getRelease
    if (release == null) {
      throw new IllegalStateException("You cannot close Task without associated release object")
    }
    val clonedRelease = clone(release)
    val clonedTask = clonedRelease.getTask(task.getId).asInstanceOf[T]
    clonedTask
  }

  def clone(release: Release): Release = {
    val clonedRelease = cloneCi(release)
    clonedRelease.setCiUid(release.getCiUid)
    val originalCiAttributes = release.get$ciAttributes()
    val clonedCiAttributes = new CiAttributes(
      originalCiAttributes.getCreatedBy,
      originalCiAttributes.getCreatedAt,
      originalCiAttributes.getLastModifiedBy,
      originalCiAttributes.getLastModifiedAt,
      originalCiAttributes.getScmTraceabilityDataId
    )
    clonedRelease.set$ciAttributes(clonedCiAttributes)
    release.get$metadata().forEach { (key, data) =>
      clonedRelease.get$metadata().put(key, data)
    }
    val taskCiUids = release.getAllTasks.asScala.map(task => task.getId -> task.getCiUid).toMap
    clonedRelease.getAllTasks.forEach(task => {
      task.setCiUid(taskCiUids(task.getId))
    })
    clonedRelease
  }
}
