package com.xebialabs.xlrelease.repository

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.repository.FacetRepository.{GenericFacetRepository, SpecializedFacetRepository}
import com.xebialabs.xlrelease.service.{ArchivingService, CiIdService}
import grizzled.slf4j.Logging

class FacetRepositoryDispatcher (val ciIdService: CiIdService,
                                 genericFacetLiveRepository: GenericFacetRepository with FacetRepository.ForLive) extends FacetRepository
    with FacetRepository.DatabaseDispatcher[FacetRepository]
    with Logging { self =>

  private var archivingService: ArchivingService = _
  private var genericFacetArchiveRepository: GenericFacetArchiveRepository = _

  def setupGenericFacetArchiveRepository(archiving: ArchivingService): Unit = {
    archivingService = archiving
    genericFacetArchiveRepository = new GenericFacetArchiveRepository(ciIdService, archiving)
  }

  def supportedTypes: Set[Type] = liveRepository.specializedRepositories.map(_.supportedType).toSet

  def isArchived(releaseId: String): Boolean = archivingService.exists(releaseId)

  def register(specializedRepo: SpecializedFacetRepository with FacetRepository.DatabaseDispatcher[SpecializedFacetRepository]): Unit = {
    require(archivingService != null)
    require(genericFacetArchiveRepository != null)
    require(specializedRepo.liveRepository.supportedType == specializedRepo.archiveRepository.supportedType)
    logger.debug(s"Registering special facet repository for ${specializedRepo.liveRepository.supportedType.toString}")
    liveRepository.register(specializedRepo.liveRepository)
    archiveRepository.register(specializedRepo.archiveRepository)
  }

  lazy val liveRepository: FacetRepository with FacetRepository.ForLive with FacetRepository.FacetTypeDispatcher =
    new FacetRepository with FacetRepository.ForLive with FacetRepository.FacetTypeDispatcher  {
      val ciIdService: CiIdService = self.ciIdService
      val genericRepository: GenericFacetRepository with FacetRepository.ForLive = genericFacetLiveRepository
    }

  lazy val archiveRepository: FacetRepository with FacetRepository.ForArchive with FacetRepository.FacetTypeDispatcher =
    new FacetRepository with FacetRepository.ForArchive with FacetRepository.FacetTypeDispatcher {
      val ciIdService: CiIdService = self.ciIdService
      val genericRepository: GenericFacetRepository with FacetRepository.ForArchive = genericFacetArchiveRepository
    }

}
