package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.Team
import com.xebialabs.xlrelease.security.SecuredCi

import java.util.{List => JList}

trait TeamRepository {
  def getTeams(containerId: String): JList[Team]

  def getTeams(container: SecuredCi): JList[Team]

  def create(containerId: String, team: Team): Team

  def delete(teamId: String): Unit

  def update(teamToUpdate: Team): Team

  def saveTeamsToPlatform(containerId: String, teams: JList[Team]): JList[Team]

  def deleteTeamsFromPlatform(containerId: String): Unit

  def deleteTeamsFromPlatform(container: SecuredCi): Unit
}
