package com.xebialabs.xlrelease.scheduler.workers

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.scheduler.workers.Worker.ExecuteJob
import com.xebialabs.xlrelease.scheduler.{Job, TaskJob}
import com.xebialabs.xlrelease.user.User
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
class UnhandledWorker(releaseActorService: ReleaseActorService) extends Worker with Logging {

  override def execute: ExecuteJob = {
    case taskJob: TaskJob[_] =>
      logger.error(s"Found unhandled job $taskJob")
      releaseActorService.failTask(taskJob.taskId, "Unable to find job worker", User.SYSTEM, None)
    case job: Job => {
      throw new IllegalArgumentException(s"Unhandled job $job")
    }
  }

  override def getOrder: Int = Integer.MAX_VALUE

}
