package com.xebialabs.xlrelease.script.builder

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.ResolvableScriptTask
import com.xebialabs.xlrelease.script.{ScriptTimeoutContext, XlrScript, XlrScriptContext}

import scala.jdk.DurationConverters._

class ScriptTaskScriptContextBuilder(xlrConfig: XlrConfig, scriptTask: ResolvableScriptTask) extends ScriptContextBuilder {
  withScriptApi().withLogger().withExecutionId(scriptTask.getExecutionId)

  val timeoutEnabled = xlrConfig.timeouts.scriptTaskTimeoutEnabled
  val timeoutExecutor = xlrConfig.timeoutExecutorThreadPool
  val timeout = xlrConfig.timeouts.scriptTaskTimeout.toJava
  val settingsKey = xlrConfig.timeouts.SCRIPT_TASK_TIMEOUT_KEY
  withTimeoutContext(new ScriptTimeoutContext(timeoutEnabled, timeoutExecutor, timeout, settingsKey))

  scriptTask.getEngine match {
    case "groovy" => withOpenApi().withGroovyDsl()
    case "jython" => withPythonSugar().withPythonGlobals().withPythonReleaseApi().withPythonUtilities()
  }

  override protected def doBuild(context: XlrScriptContext): Unit = {
    context.addDomainObjects(safe(scriptTask))

    val xlrScriptName = s"${scriptTask.getType.toString}[${scriptTask.getId}]"
    val xlrScript = XlrScript.byContent(xlrScriptName, scriptTask.getScript, wrap = true, checkPermissions = true)
    context.addScript(xlrScript)
  }

}