package com.xebialabs.xlrelease.service

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.repository.IdType

trait ReleaseServiceExt {
  self: ReleaseService =>

  def getTriggerReleaseBlocker(template: Release): Option[String] = {
    val templateLink = s"[${template.getTitle}](#/templates/${IdType.DOMAIN.convertToViewId(template.getId)})"
    val canTriggerReleases = template.isAllowConcurrentReleasesFromTrigger || (getRunningTriggeredReleasesCount(template.getCiUid) == 0)
    if (!canTriggerReleases) {
      val runningReleasesCount = getRunningTriggeredReleasesCount(template.getCiUid)
      Some(
        s"Allow concurrent triggered releases is disabled on template $templateLink and $runningReleasesCount ${if (runningReleasesCount == 1) "release is" else "releases are"} already running"
      )
    } else {
      None
    }
  }
}
