package com.xebialabs.xlrelease.upgrade.liquibase

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT

/**
  * Upgrades that run before any other upgrades and only for xlReleaseVersion
  */
trait BeforeUpgrade {

  def repositoryVersionService: RepositoryVersionService

  protected def xlReleaseVersion(): Version

  protected def doUpgrade(): Unit

  def upgrade(): Unit = {
    try {
      val databaseVersion = repositoryVersionService.readVersionOfComponent(XL_RELEASE_COMPONENT)
      if (xlReleaseVersion().equals(databaseVersion)) {
        doUpgrade()
      }
    } catch {
      case _: RuntimeException => // ignore, no XL_VERSION table found
    }
  }

}
