package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
@Consumes({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
public class ConfigurationItemsReaderWriter extends AbstractConfigurationItemReaderWriter implements MessageBodyReader<Collection<ConfigurationItem>>, MessageBodyWriter<Collection<ConfigurationItem>> {

    @Autowired
    public ConfigurationItemsReaderWriter(RepositoryFactory repositoryFactory, XlrFormatFactory formats, ConfigurationRepository configurationRepository) {
        super(repositoryFactory, formats, configurationRepository);
    }

    @Override
    public Collection<ConfigurationItem> readFrom(Class<Collection<ConfigurationItem>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ConfigurationItemConverter converter = createConverter();
        CiListReader reader = formats.createCiListReader(entityStream, mediaType);
        Collection<ConfigurationItem> result = converter.readCis(reader);
        // Resolve the CI references that were found by the converter while parsing
        converter.resolveReferences(repository);
        return result;
    }

    @Override
    public void writeTo(Collection<ConfigurationItem> configurationItems, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ConfigurationItemConverter converter = createConverter();
        PrintWriter outputWriter = new PrintWriter(entityStream, false, StandardCharsets.UTF_8);
        CiWriter writer = formats.createCiWriter(mediaType, outputWriter);
        converter.writeCis(configurationItems, writer, Integer.MAX_VALUE);
        outputWriter.flush();
    }

    @Override
    public long getSize(Collection<ConfigurationItem> configurationItems, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

}
