package com.xebialabs.deployit.plumbing.authentication;

import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class ReleaseAuthenticationFailureHandler implements AuthenticationFailureHandler {
    @Override
    public void onAuthenticationFailure(final HttpServletRequest request,
                                        final HttpServletResponse response,
                                        final AuthenticationException exception) throws IOException {
        if (exception instanceof DisabledException) {
            response.sendError(HttpStatus.FORBIDDEN.value(), exception.getMessage());
        } else {
            response.sendError(HttpStatus.UNAUTHORIZED.value(), exception.getMessage());
        }
    }
}