package com.xebialabs.xlrelease.actors

import com.xebialabs.deployit.engine.spi.exception.{HttpResponseCodeResult, SuppressStackTrace}

import javax.ws.rs.core.Response.Status._
import scala.beans.BeanProperty

/**
 * Remote exception should wrap any exception that might be serialized.
 */
class RemoteException extends RuntimeException {
  @BeanProperty
  var msg: String = _

  @BeanProperty
  var responseStatusCode: Int = BAD_REQUEST.getStatusCode

  @BeanProperty
  var suppressStackTrace: Boolean = false

  def this(original: Throwable) = {
    this()
    this.initCause(original)
    this.setMsg(original.getMessage)
    this.setStackTrace(original.getStackTrace)
    this.setResponseStatusCode(originalResponseStatus(original))
    this.setSuppressStackTrace(shouldSuppressStackTrace(original))
  }

  override def getMessage: String = {
    this.getMsg
  }

  private def shouldSuppressStackTrace(exception: Throwable): Boolean = {
    val annotation = exception.getClass.getAnnotation(classOf[SuppressStackTrace])
    if (null != annotation) {
      annotation.suppressStackTrace
    } else {
      false
    }
  }

  private def originalResponseStatus(exception: Throwable): Int = {
    val annotation = exception.getClass.getAnnotation(classOf[HttpResponseCodeResult])
    if (null != annotation) {
      annotation.statusCode()
    } else {
      exception match {
        case _: IllegalArgumentException => BAD_REQUEST.getStatusCode
        case _: javax.ws.rs.NotFoundException => NOT_FOUND.getStatusCode
        case _: javax.ws.rs.NotAllowedException => METHOD_NOT_ALLOWED.getStatusCode
        case _ => INTERNAL_SERVER_ERROR.getStatusCode
      }
    }
  }

}
