package com.xebialabs.xlrelease.actors.initializer

import com.xebialabs.deployit.ServerState
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.license.LicenseDBSyncInitializerService
import com.xebialabs.xlrelease.scheduler.JobQueueServices
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class ActorSystemInitializer @Autowired()(xlrConfig: XlrConfig,
                                          actorInitializers: java.util.List[ActorInitializer],
                                          licenseDBSync: LicenseDBSyncInitializerService,
                                          subscriptionInitializers: java.util.List[_ <: SubscriptionInitializer],
                                          jobQueueServices: JobQueueServices) extends Logging {

  @volatile
  private var initializationCompleted: Boolean = false

  def initialize(): Unit = {
    val mode: String = xlrConfig.clusterMode.toString
    logger.info(s"Initializing actor system in $mode mode.")

    logger.debug("Initializing actors...")
    actorInitializers.forEach(_.initialize())

    licenseDBSync.initialize()
    logger.debug("Initializing subscriptions...")
    if (ServerState.getInstance().getCurrentMode == ServerState.Mode.MAINTENANCE) {
      logger.warn("[MAINTENANCE MODE] Webhook triggers - DISABLED")
    } else {
      subscriptionInitializers.asScala.sortBy(_.getOrder).foreach(subscriptionInitializer => {
        try {
          subscriptionInitializer.initialize()
        } catch {
          case e: Exception => logger.error(s"Unable to initialize ${subscriptionInitializer.getClass.getName}", e)
        }
      })
    }

    logger.debug("Initializing job queue services")
    jobQueueServices.start()
    initializationCompleted = true;
  }

  def isInitializationCompleted: Boolean = initializationCompleted
}
