package com.xebialabs.xlrelease.api.utils;

public class WordUtils {

    public static String convertToTitleCase(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }

        value = value.toLowerCase().stripLeading();
        final int valueLen = value.length();
        final int[] charPoints = new int[valueLen];
        int outOffset = 0;
        final Integer delimiter = Character.codePointAt(new char[]{' '}, 0);
        boolean capitalizeNext = true;
        for (int index = 0; index < valueLen; ) {
            final int codePoint = value.codePointAt(index);

            if (delimiter == codePoint) {
                capitalizeNext = outOffset != 0;
                index += Character.charCount(codePoint);
            } else if (capitalizeNext) {
                final int titleCaseCodePoint = Character.toTitleCase(codePoint);
                charPoints[outOffset++] = titleCaseCodePoint;
                index += Character.charCount(titleCaseCodePoint);
                capitalizeNext = false;
            } else {
                charPoints[outOffset++] = codePoint;
                index += Character.charCount(codePoint);
            }
        }
        if (outOffset != 0) {
            return new String(charPoints, 0, outOffset);
        }
        return value;
    }
}
