package com.xebialabs.xlrelease.domain.tasks.group;

import java.util.List;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.views.LinkView;
import com.xebialabs.xlrelease.views.TaskFullView;

import static com.xebialabs.xlrelease.builder.TaskBuilder.newParallelGroup;
import static java.util.stream.Collectors.toList;

@Component
public class ParallelGroupViewConverter extends TaskGroupViewConverter<ParallelGroup> {

    @Override
    public TaskFullView toFullView(final ParallelGroup task, final List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView v = super.toFullView(task, allowedTaskTypesForAuthenticatedUser);
        v.setLinks(task.getLinks().stream().map(LinkView::new).collect(toList()));
        return v;
    }

    @Override
    protected ParallelGroup fromView(final TaskFullView view) {
        return newParallelGroup().build();
    }

    @Override
    protected Class<ParallelGroup> getTaskClass() {
        return ParallelGroup.class;
    }
}