package com.xebialabs.xlrelease.domain.tasks.script;

import java.util.List;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.converters.BaseTaskViewConverter;

import static com.xebialabs.xlrelease.builder.TaskBuilder.newScriptTask;

@Component
public class ScriptTaskViewConverter extends BaseTaskViewConverter<ScriptTask> {

    @Override
    public TaskFullView toFullView(final ScriptTask task, final List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView v = super.toFullView(task, allowedTaskTypesForAuthenticatedUser);
        v.setScript(task.getScript());
        v.setIgnoreScriptVariableInterpolation(task.isScriptInterpolationOff());
        return v;
    }

    @Override
    public ScriptTask toTask(final TaskFullView view) {
        final ScriptTask scriptTask = super.toTask(view);
        scriptTask.setIgnoreScriptVariableInterpolation(view.isIgnoreScriptVariableInterpolation());
        return scriptTask;
    }

    @Override
    protected ScriptTask fromView(final TaskFullView view) {
        return newScriptTask()
                .withScript(view.getScript())
                .build();
    }

    @Override
    protected Class<ScriptTask> getTaskClass() {
        return ScriptTask.class;
    }
}