package com.xebialabs.xlrelease.json

import com.fasterxml.jackson.core.`type`.TypeReference
import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.databind.node.ObjectNode
import com.fasterxml.jackson.module.scala.DefaultScalaModule
import com.xebialabs.xlrelease.export.TemplateJsonHelper.getTasksFromRelease
import com.xebialabs.xlrelease.json.JsonKeys._
import com.xebialabs.xlrelease.json.JsonReplacements.{JSONArrayOps, JSONObjectOps, typeFound}
import org.codehaus.jettison.json.JSONObject


object JsonUtils {
  val objectMapper = new ObjectMapper()
  objectMapper.registerModule(DefaultScalaModule)

  implicit class ReleaseJsonOps(val releaseJson: String) extends AnyVal {

    def withoutUnknownTypes: String = {
      val release = objectMapper.readValue(releaseJson, new TypeReference[ObjectNode]() {})
      val tasks = getTasksFromRelease(release)
      tasks.forEach(_.fixTask(Some(release)))
      release.toSeq(variables).foreach(variable => variable.asInstanceOf[ObjectNode].fixInnerType(valueProvider))
      release.get("status").asText match {
        case "COMPLETED" | "ABORTED" => {
          release.toSeq(extensions).foreach(extension => extension.asInstanceOf[ObjectNode].fixDashboard())
          tasks.forEach(_.fixJsonArray(facets))
        }
        case _ =>
      }
      objectMapper.writeValueAsString(release)
    }
  }

  implicit class TaskBackupJsonOps(val taskBackupJson: String) extends AnyVal {

    def withoutUnknownProps: String = {
      val task = objectMapper.readValue(taskBackupJson, new TypeReference[ObjectNode]() {})
      task.fixTask()
      task.fixJsonArray(facets)
      task.toString
    }
  }

  implicit class DashboardJsonOps(val extensionJson: String) extends AnyVal {

    def withoutUnknownTiles: String = {
      val dashboard = objectMapper.readValue(extensionJson, new TypeReference[ObjectNode]() {})
      dashboard.fixDashboard()
      objectMapper.writeValueAsString(dashboard)
    }
  }

  implicit class TaskFacetJsonOps(val facet: String) extends AnyVal {

    def withoutUnknownProps: String = {
      val taskFacet = objectMapper.readValue(facet, new TypeReference[ObjectNode]() {})
      taskFacet.fixProperties()
      objectMapper.writeValueAsString(taskFacet)
    }

    def isRegistered: Boolean = typeFound(new JSONObject(facet).getString("type"))
  }
}
