package com.xebialabs.xlrelease.notifications.actors.extension

import akka.actor.Actor.Receive
import akka.actor.{Actor, ActorRef, ActorSystem}
import com.xebialabs.xlrelease.actors.ReleaseExecutionActor
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages.ExtensionCommand
import com.xebialabs.xlrelease.actors.extension.ActorExtensionHandlerFactory
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.notifications.actors.extension.TaskWatcherExecutionActorMessages.{AddWatcher, RemoveWatcher, UpdateWatchers}
import com.xebialabs.xlrelease.service.TaskWatchersService
import org.springframework.stereotype.Component

import java.util.{Set => JSet}

object TaskWatcherExecutionActorMessages {

  case class AddWatcher(taskId: String, watcher: String) extends ExtensionCommand

  case class RemoveWatcher(taskId: String, watcher: String) extends ExtensionCommand

  case class UpdateWatchers(taskId: String, watchers: JSet[String]) extends ExtensionCommand

}

@Component
class TaskWatcherExecutionActorHandlerFactory(val actorSystem: ActorSystem,
                                              taskWatchersService: TaskWatchersService)
  extends ActorExtensionHandlerFactory {

  override def supports(clazz: Class[_ <: Actor]): Boolean = classOf[ReleaseExecutionActor].isAssignableFrom(clazz)

  override def getHandler(self: ActorRef, sender: () => ActorRef, release: => Release): Receive = {
    case AddWatcher(taskId, watcher) => replyOrFail(sender) {
      taskWatchersService.addWatcher(taskId, watcher)
    }
    case RemoveWatcher(taskId, watcher) => replyOrFail(sender) {
      taskWatchersService.removeWatcher(taskId, watcher)
    }
    case UpdateWatchers(taskId, watchers) => replyOrFail(sender) {
      taskWatchersService.updateWatchers(taskId, watchers)
    }
  }
}
