package com.xebialabs.xlrelease.principaldata;

public class UserData {
    public static final UserData NOT_FOUND = new UserData();
    private String email;
    private String fullName;
    private String externalId;
    private final boolean found;

    public UserData(String email, String fullName) {
        this.email = email;
        this.fullName = fullName;
        this.found = true;
    }

    public UserData(String email, String fullName, String externalId) {
        this(email, fullName);
        this.externalId = externalId;
    }

    private UserData() {
        this.found = false;
    }

    public String getEmail() {
        return email;
    }

    public String getFullName() {
        return fullName;
    }

    public String getExternalId() {
        return externalId;
    }

    public boolean isFound() {
        return found;
    }
}
